/// <reference path="./internal_*.d.ts" />
declare namespace io.ejekta.kambrik.internal.mixins {
    interface StructurePoolAccessor {
        abstract getElements(): Internal.ObjectArrayList<Internal.StructurePoolElement>;
        abstract getElementCounts(): Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>;
        abstract setElementCounts(arg0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>): void;
        get elements(): Internal.ObjectArrayList<Internal.StructurePoolElement>
        get elementCounts(): Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>
        set elementCounts(arg0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>)
    }
    type StructurePoolAccessor_ = StructurePoolAccessor;
}
declare namespace vazkii.botania.mixin {
    interface LevelAccessor {
        abstract getNeighborUpdater(): Internal.NeighborUpdater;
        get neighborUpdater(): Internal.NeighborUpdater
        (): Internal.NeighborUpdater_;
    }
    type LevelAccessor_ = LevelAccessor | (()=> Internal.NeighborUpdater_);
}
declare namespace Internal {
    class WorldGenRegion implements Internal.WorldGenRegionAccessor, Internal.WorldGenLevel, com.telepathicgrunt.repurposedstructures.mixins.world.WorldGenRegionAccessor {
        constructor(arg0: Internal.ServerLevel_, arg1: Internal.List_<Internal.ChunkAccess>, arg2: Internal.ChunkStatus_, arg3: number)
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_): Internal.Player;
        getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSeed(): number;
        dayTime(): number;
        getSignal(arg0: BlockPos_, arg1: Internal.Direction_): number;
        isUnobstructed(arg0: Internal.Entity_, arg1: Internal.VoxelShape_): boolean;
        "scheduleTick(net.minecraft.core.BlockPos,net.minecraft.world.level.material.Fluid,int,net.minecraft.world.ticks.TickPriority)"(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number, arg3: Internal.TickPriority_): void;
        getMaxSection(): number;
        getLevelData(): Internal.LevelData;
        getBrightness(arg0: Internal.LightLayer_, arg1: BlockPos_): number;
        getSectionYFromSectionIndex(arg0: number): number;
        "getNearestPlayer(net.minecraft.world.entity.ai.targeting.TargetingConditions,net.minecraft.world.entity.LivingEntity,double,double,double)"(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: number, arg3: number, arg4: number): Internal.Player;
        getSize(): number;
        players(): Internal.List<Internal.Player>;
        getBiomeManager(): Internal.BiomeManager;
        getRandom(): Internal.RandomSource;
        isEmptyBlock(arg0: BlockPos_): boolean;
        removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        getMaxLocalRawBrightness(arg0: BlockPos_, arg1: number): number;
        playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_): void;
        getBlockCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight(arg0: BlockPos_): boolean;
        getTimeOfDay(arg0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        getHeightmapPos(arg0: Internal.Heightmap$Types_, arg1: BlockPos_): BlockPos;
        blockUpdated(arg0: BlockPos_, arg1: Internal.Block_): void;
        setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        isClientSide(): boolean;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_): Internal.List<T>;
        getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        "getNearestPlayer(net.minecraft.world.entity.ai.targeting.TargetingConditions,net.minecraft.world.entity.LivingEntity)"(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_): Internal.Player;
        "scheduleTick(net.minecraft.core.BlockPos,net.minecraft.world.level.material.Fluid,int)"(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number): void;
        getBlockStates(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels(arg0: BlockPos_): number;
        dimensionType(): Internal.DimensionType;
        getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number): void;
        getLoadedChunk(arg0: number, arg1: number): Internal.ChunkAccess;
        "getEntities(net.minecraft.world.level.entity.EntityTypeTest,net.minecraft.world.phys.AABB,java.util.function.Predicate)"<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): Internal.Player;
        getClass(): typeof any;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        getSeaLevel(): number;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: number, arg1: number): boolean;
        getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex(arg0: number): number;
        getDirectSignalTo(arg0: BlockPos_): number;
        ensureCanWrite(arg0: BlockPos_): boolean;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: number, arg2: number, arg3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: BlockPos_, arg1: BlockPos_): boolean;
        destroyBlock(arg0: BlockPos_, arg1: boolean): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number): void;
        "getNearestPlayer(double,double,double,double,java.util.function.Predicate)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        addFreshEntity(arg0: Internal.Entity_): boolean;
        getChunk(arg0: number, arg1: number): Internal.ChunkAccess;
        hasSignal(arg0: BlockPos_, arg1: Internal.Direction_): boolean;
        "isOutsideBuildHeight(int)"(arg0: number): boolean;
        getCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk(arg0: BlockPos_): Internal.ChunkAccess;
        isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        getWorldBorder(): Internal.WorldBorder;
        toString(): string;
        getCache(): Internal.List<any>;
        getMaxLocalRawBrightness(arg0: BlockPos_): number;
        isUnobstructed(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.CollisionContext_): boolean;
        notifyAll(): void;
        "isOutsideBuildHeight(net.minecraft.core.BlockPos)"(arg0: BlockPos_): boolean;
        "scheduleTick(net.minecraft.core.BlockPos,net.minecraft.world.level.block.Block,int,net.minecraft.world.ticks.TickPriority)"(arg0: BlockPos_, arg1: Internal.Block_, arg2: number, arg3: Internal.TickPriority_): void;
        getLastPos(): Internal.ChunkPos;
        "gameEvent(net.minecraft.world.level.gameevent.GameEvent,net.minecraft.core.BlockPos,net.minecraft.world.level.gameevent.GameEvent$Context)"(arg0: Internal.GameEvent_, arg1: BlockPos_, arg2: Internal.GameEvent$Context_): void;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: BlockPos_): boolean;
        getBiome(arg0: BlockPos_): Internal.Holder<Internal.Biome>;
        getFirstPos(): Internal.ChunkPos;
        "getNearestPlayer(net.minecraft.world.entity.Entity,double)"(arg0: Internal.Entity_, arg1: number): Internal.Player;
        "noCollision(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(arg0: BlockPos_): number;
        wait(arg0: number): void;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number, arg3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        "gameEvent(net.minecraft.world.entity.Entity,net.minecraft.world.level.gameevent.GameEvent,net.minecraft.core.BlockPos)"(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: BlockPos_): void;
        getStructureManager(): Internal.StructureManager;
        gameEvent(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        "getEntities(net.minecraft.world.entity.Entity,net.minecraft.world.phys.AABB,java.util.function.Predicate)"(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: number, arg3: number, arg4: number): Internal.Player;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        neighborShapeChanged(arg0: Internal.Direction_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: BlockPos_, arg4: number, arg5: number): void;
        getControlInputSignal(arg0: BlockPos_, arg1: Internal.Direction_, arg2: boolean): number;
        getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        getBlockState(arg0: BlockPos_): Internal.BlockState;
        findFreePosition(arg0: Internal.Entity_, arg1: Internal.VoxelShape_, arg2: Vec3d_, arg3: number, arg4: number, arg5: number): Optional<Vec3d>;
        clipWithInteractionOverride(arg0: Vec3d_, arg1: Vec3d_, arg2: BlockPos_, arg3: Internal.VoxelShape_, arg4: Internal.BlockState_): Internal.BlockHitResult;
        notify(): void;
        playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer(arg0: Internal.Entity_, arg1: number): Internal.Player;
        hasNeighborSignal(arg0: BlockPos_): boolean;
        getLightEmission(arg0: BlockPos_): number;
        getBlockFloorHeight(arg0: BlockPos_): number;
        getBlockStatesIfLoaded(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getShade(arg0: number, arg1: number, arg2: number, arg3: boolean): number;
        static create(arg0: number, arg1: number): Internal.LevelHeightAccessor;
        clip(arg0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Optional<T>;
        getRawBrightness(arg0: BlockPos_, arg1: number): number;
        "gameEvent(net.minecraft.world.entity.Entity,net.minecraft.world.level.gameevent.GameEvent,net.minecraft.world.phys.Vec3)"(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: Vec3d_): void;
        addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky(arg0: BlockPos_): boolean;
        enabledFeatures(): Internal.FeatureFlagSet;
        getMoonPhase(): number;
        isUnobstructed(arg0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: Internal.List_<T>, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number): T;
        getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        addFreshEntityWithPassengers(arg0: Internal.Entity_): void;
        getPlayerByUUID(arg0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater(arg0: BlockPos_): boolean;
        holderLookup<T>(arg0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        "noCollision(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        wait(): void;
        getNearbyPlayers(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY(arg0: number): number;
        getCenter(): Internal.ChunkPos;
        getServer(): Internal.MinecraftServer;
        levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number): boolean;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision(arg0: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getLevel(): Internal.ServerLevel;
        isOldChunkAround(arg0: Internal.ChunkPos_, arg1: number): boolean;
        getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getBestNeighborSignal(arg0: BlockPos_): number;
        hasChunk(arg0: number, arg1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: Internal.AABB_): Internal.List<T>;
        wait(arg0: number, arg1: number): void;
        "getNearestPlayer(double,double,double,double,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): Internal.Player;
        getMoonBrightness(): number;
        noCollision(arg0: Internal.AABB_): boolean;
        isWaterAt(arg0: BlockPos_): boolean;
        getDirectSignal(arg0: BlockPos_, arg1: Internal.Direction_): number;
        getLightEngine(): Internal.LevelLightEngine;
        getEntityCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight(arg0: Internal.VoxelShape_, arg1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        setCurrentlyGenerating(arg0: Internal.Supplier_<string>): void;
        gameEvent(arg0: Internal.GameEvent_, arg1: BlockPos_, arg2: Internal.GameEvent$Context_): void;
        getModelDataManager(): Internal.ModelDataManager;
        noCollision(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number, arg3: Internal.TickPriority_): void;
        isOutsideBuildHeight(arg0: number): boolean;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine(arg0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        "gameEvent(net.minecraft.world.level.gameevent.GameEvent,net.minecraft.world.phys.Vec3,net.minecraft.world.level.gameevent.GameEvent$Context)"(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        getFluidState(arg0: BlockPos_): Internal.FluidState;
        gameEvent(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: Vec3d_): void;
        getChunkSource(): Internal.ChunkSource;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        registryAccess(): Internal.RegistryAccess;
        findSupportingBlock(arg0: Internal.Entity_, arg1: Internal.AABB_): Optional<BlockPos>;
        "scheduleTick(net.minecraft.core.BlockPos,net.minecraft.world.level.block.Block,int)"(arg0: BlockPos_, arg1: Internal.Block_, arg2: number): void;
        levelEvent(arg0: number, arg1: BlockPos_, arg2: number): void;
        getExistingBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        hashCode(): number;
        nextSubTickCount(): number;
        gameEvent(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: BlockPos_): void;
        getChunkForCollisions(arg0: number, arg1: number): Internal.BlockGetter;
        containsAnyLiquid(arg0: Internal.AABB_): boolean;
        getMaxLightLevel(): number;
        equals(arg0: any): boolean;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number, arg6: Internal.AABB_): T;
        isAreaLoaded(arg0: BlockPos_, arg1: number): boolean;
        static traverseBlocks<T, C>(arg0: Vec3d_, arg1: Vec3d_, arg2: C, arg3: Internal.BiFunction_<C, BlockPos, T>, arg4: Internal.Function_<C, T>): T;
        get seed(): number
        get maxSection(): number
        get levelData(): Internal.LevelData
        get size(): number
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        get class(): typeof any
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get cache(): Internal.List<any>
        get lastPos(): Internal.ChunkPos
        get firstPos(): Internal.ChunkPos
        get structureManager(): Internal.StructureManager
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get center(): Internal.ChunkPos
        get server(): Internal.MinecraftServer
        /**
         * @deprecated
        */
        get level(): Internal.ServerLevel
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        set currentlyGenerating(arg0: Internal.Supplier_<string>)
        get modelDataManager(): Internal.ModelDataManager
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
        readonly writeRadiusCutoff: number;
    }
    type WorldGenRegion_ = WorldGenRegion;
    interface IClientBlockExtensions {
        addHitEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.HitResult_, arg3: Internal.ParticleEngine_): boolean;
        of(arg0: Internal.BlockState_): this;
        of(arg0: Internal.Block_): this;
        addDestroyEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.ParticleEngine_): boolean;
        "of(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): this;
        areBreakingParticlesTinted(arg0: Internal.BlockState_, arg1: Internal.ClientLevel_, arg2: BlockPos_): boolean;
        getFogColor(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: Internal.Vector3d_, arg5: number): Internal.Vector3d;
        "of(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): this;
        readonly DEFAULT: Internal.IClientBlockExtensions;
    }
    type IClientBlockExtensions_ = IClientBlockExtensions;
    class VillagerTradesEvent extends net.minecraftforge.eventbus.api.Event {
        constructor()
        constructor(arg0: Internal.Int2ObjectMap_<Internal.List<Internal.VillagerTrades$ItemListing>>, arg1: Internal.VillagerProfession_)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        getType(): Internal.VillagerProfession;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        getTrades(): Internal.Int2ObjectMap<Internal.List<Internal.VillagerTrades$ItemListing>>;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        get type(): Internal.VillagerProfession
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
        get trades(): Internal.Int2ObjectMap<Internal.List<Internal.VillagerTrades$ItemListing>>
    }
    type VillagerTradesEvent_ = VillagerTradesEvent;
    abstract class CreativePacket {
        constructor()
        getClass(): typeof any;
        toString(): string;
        requiresServer(arg0: Internal.Player_): void;
        abstract executeServer(arg0: Internal.ServerPlayer_): void;
        abstract executeClient(arg0: Internal.Player_): void;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        requiresClient(arg0: Internal.Player_): void;
        equals(arg0: any): boolean;
        execute(arg0: Internal.Player_): void;
        get class(): typeof any
    }
    type CreativePacket_ = CreativePacket;
    interface ReflectionBasedSerialization {
    }
    type ReflectionBasedSerialization_ = ReflectionBasedSerialization;
    class Interaction extends Internal.Entity implements Internal.Attackable, Internal.Targeting {
        constructor(arg0: Internal.EntityType_<any>, arg1: Internal.Level_)
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        etf$getType(): Internal.EntityType<any>;
        getUpVector(arg0: number): Vec3d;
        getXRot(): number;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        isSuppressingBounce(): boolean;
        getBlockZ(): number;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(arg0: Internal.SoundEvent_): void;
        setCulled(value: boolean): void;
        getPitch(): number;
        isOnFire(): boolean;
        rotate(arg0: Internal.Rotation_): number;
        getPositionCodec(): Internal.VecDeltaCodec;
        handler$efh000$postTurnHook(arg0: Internal.CallbackInfo_): void;
        getPassengersAndSelf(): Internal.Stream<any>;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        emf$isOnGround(): boolean;
        gameEvent(arg0: Internal.GameEvent_): void;
        alwaysAccepts(): boolean;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        setUUID(arg0: Internal.UUID_): void;
        handler$edb000$alcoholMovement(cir: Internal.CallbackInfoReturnable_<any>): void;
        checkBelowWorld(): void;
        isVisuallyCrawling(): boolean;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setMotionZ(z: number): void;
        tdv$shouldUpdateDynamicLight(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        ignoreExplosion(): boolean;
        canFreeze(): boolean;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        getBlockY(): number;
        handler$fmm000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isSpectator(): boolean;
        isInWaterOrBubble(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getPortalCooldown(): number;
        emf$isGlowing(): boolean;
        getItem(): Internal.ItemStack;
        getRandomZ(arg0: number): number;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        handler$dcj000$injectDataLoading(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        getPosition(arg0: number): Vec3d;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        etf$getVelocity(): Vec3d;
        canUpdate(arg0: boolean): void;
        distanceToSqr(arg0: Vec3d_): number;
        getEyeInFluidType(): Internal.FluidType;
        resetFallDistance(): void;
        handler$zzn000$onRemove(arg0: Internal.CallbackInfo_): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        isSteppingCarefully(): boolean;
        setLevel(arg0: Internal.Level_): void;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        tdv$resetDynamicLight(): void;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        getBlockX(): number;
        getEncodeId(): string;
        getY(arg0: number): number;
        emf$prevPitch(): number;
        canaryOnBlockCacheDeleted(): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setInvisible(arg0: boolean): void;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        tdv$getDynamicLightZ(): number;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getYaw(): number;
        emf$isTouchingWater(): boolean;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        hasPermissions(arg0: number): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setCustomNameVisible(arg0: boolean): void;
        isAlliedTo(arg0: Internal.Team_): boolean;
        setOutOfCamera(value: boolean): void;
        getRemainingFireTicks(): number;
        getControllingPassenger(): Internal.LivingEntity;
        handler$caf000$baseTick(arg0: Internal.CallbackInfo_): void;
        getScriptType(): Internal.ScriptType;
        onlyOpCanSetNbt(): boolean;
        setChopData(arg0: Internal.SyncedChopData_): Internal.SyncedChopData;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        fireImmune(): boolean;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        getMaxFallDistance(): number;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        getEyeY(): number;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        isDescending(): boolean;
        getChopData(): Internal.SyncedChopData;
        emf$getPitch(): number;
        setItemSlot(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): void;
        getYHeadRot(): number;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        playerTouch(arg0: Internal.Player_): void;
        addTag(arg0: string): boolean;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        getTeam(): Internal.Team;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        setTicksFrozen(arg0: number): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        getMyRidingOffset(): number;
        canStartSwimming(): boolean;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        etf$getPose(): Internal.Pose;
        hasCustomName(): boolean;
        isCulled(): boolean;
        isLiving(): boolean;
        getX(): number;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        isVehicle(): boolean;
        tdv$getLuminance(): number;
        handler$cac000$l2library_overrideClientGlow_isCurrentlyGlowing(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isAttackable(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getXaero_OPAC_deadPlayer(): Internal.UUID;
        setIsInPowderSnow(arg0: boolean): void;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        getSlot(arg0: number): Internal.SlotAccess;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        emf$isInLava(): boolean;
        getTeamId(): string;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        isUnderWater(): boolean;
        getSwimHighSpeedSplashSound(): Internal.SoundEvent;
        stopRiding(): void;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        getX(arg0: number): number;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        callUnsetRemoved(): void;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        collide(arg0: Vec3d_): Vec3d;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        hasPassenger(arg0: Internal.Entity_): boolean;
        tdv$lambdynlights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        emf$getZ(): number;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        handleInsidePortal(arg0: BlockPos_): void;
        create$callSetLevel(arg0: Internal.Level_): void;
        setTouchingWater(arg0: boolean): void;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        isOnRails(): boolean;
        restoreFrom(arg0: Internal.Entity_): void;
        getDimensionChangingDelay(): number;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        emf$getYaw(): number;
        setPos(arg0: number, arg1: number, arg2: number): void;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        notify(): void;
        getFirstTick(): boolean;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        setXaero_OPAC_deadPlayer(arg0: Internal.UUID_): void;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        getStringUuid(): string;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        getRotationVector(): Internal.Vec2;
        refreshDimensions(): void;
        self(): Internal.Entity;
        isSprinting(): boolean;
        etf$getBlockY(): number;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getMotionY(): number;
        canCollideWith(arg0: Internal.Entity_): boolean;
        setShiftKeyDown(arg0: boolean): void;
        getEyePosition(arg0: number): Vec3d;
        getPassengers(): Internal.EntityArrayList;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getServer(): Internal.MinecraftServer;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        getFirstPassenger(): Internal.Entity;
        isAddedToWorld(): boolean;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        tdv$isDynamicLightEnabled(): boolean;
        setXRot(arg0: number): void;
        checkSlowFallDistance(): void;
        getSoundSource(): Internal.SoundSource;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getPose(): Internal.Pose;
        touchingUnloadedChunk(): boolean;
        tdv$setDynamicLightEnabled(arg0: boolean): void;
        getLookAngle(): Vec3d;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        emf$isOnFire(): boolean;
        getMotionZ(): number;
        etf$getUuid(): Internal.UUID;
        removeVehicle(): void;
        setXaero_OPAC_lastChunkEntryDimension(arg0: Internal.ResourceKey_<any>): void;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        setZ(z: number): void;
        getY(): number;
        ejectPassengers(): void;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getProfile(): Internal.GameProfile;
        static setViewScale(arg0: number): void;
        emf$isAlive(): boolean;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        emf$getVelocity(): Vec3d;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        etf$writeNbt(compound: Internal.CompoundTag_): Internal.CompoundTag;
        setTimeout(): void;
        position(): Vec3d;
        displayFireAnimation(): boolean;
        isOutOfCamera(): boolean;
        turn(arg0: number, arg1: number): void;
        getAirSupply(): number;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        etf$canBeBright(): boolean;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isAnimal(): boolean;
        isPlayer(): boolean;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        setY(y: number): void;
        getFeetBlockState(): Internal.BlockState;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        canChangeDimensions(): boolean;
        getCommandSenderWorld(): Internal.Level;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        setXaero_OPAC_lootOwner(arg0: Internal.UUID_): void;
        setAlcohol(alcoholLevel: Internal.AlcoholLevel_): void;
        handler$cjb000$isInsideWall(arg0: Internal.CallbackInfoReturnable_<any>, arg1: number, arg2: Internal.AABB_): void;
        setSharedFlag(arg0: number, arg1: boolean): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        getMaxAirSupply(): number;
        isVisuallySwimming(): boolean;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        handler$dcj000$injectDataSaving(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfoReturnable_<any>): void;
        getFacing(): Internal.Direction;
        emf$isWet(): boolean;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>, arg1: boolean): boolean;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        isSwimming(): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        tdv$dynamicLightTick(): void;
        getTarget(): Internal.LivingEntity;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        static collideBoundingBox(arg0: Internal.Entity_, arg1: Vec3d_, arg2: Internal.AABB_, arg3: Internal.Level_, arg4: Internal.List_<any>): Vec3d;
        setSprinting(arg0: boolean): void;
        setPortalCooldown(): void;
        setX(x: number): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        getPortalWaitTime(): number;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        isInWater(): boolean;
        getBlockStateOn(): Internal.BlockState;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(x: number, y: number, z: number, yaw: number, pitch: number): void;
        isInvisibleTo(arg0: Internal.Player_): boolean;
        setAirSupply(arg0: number): void;
        getRootVehicle(): Internal.Entity;
        getOnPos(): BlockPos;
        etf$getWorld(): Internal.Level;
        save(arg0: Internal.CompoundTag_): boolean;
        isNoGravity(): boolean;
        getStepHeight(): number;
        acceptsFailure(): boolean;
        etf$getBlockPos(): BlockPos;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        handler$efh000$preTurnHook(arg0: Internal.CallbackInfo_): void;
        setOldPosAndRot(): void;
        getXaero_OPAC_lastChunkEntryDimension(): Internal.ResourceKey<any>;
        emf$getY(): number;
        getXaero_OPAC_lootOwner(): Internal.UUID;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        updateSwimming(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        wait(): void;
        getUuid(): Internal.UUID;
        spawn(): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        shouldShowName(): boolean;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        kill(): void;
        getSwimSplashSound(): Internal.SoundEvent;
        isOnPortalCooldown(): boolean;
        animateHurt(arg0: number): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        getParts(): Internal.PartEntity<any>[];
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        emf$getX(): number;
        deserializeNBT(arg0: Internal.Tag_): void;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        revive(): void;
        emf$hasPassengers(): boolean;
        serializeNBT(): Internal.CompoundTag;
        getBbWidth(): number;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        getForgePersistentData(): Internal.CompoundTag;
        addDeltaMovement(arg0: Vec3d_): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        getAlcohol(): Internal.AlcoholLevel;
        "getName()"(): net.minecraft.network.chat.Component;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        emf$hasVehicle(): boolean;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        tdv$getDynamicLightWorld(): Internal.Level;
        getTicksRequiredToFreeze(): number;
        /**
         * @deprecated
        */
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        getYRot(): number;
        isAlive(): boolean;
        tdv$getDynamicLightX(): number;
        emf$prevZ(): number;
        getBbHeight(): number;
        canaryOnBlockCacheSet(arg0: Internal.BlockState_): void;
        getUsername(): string;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        getViewVector(arg0: number): Vec3d;
        getTags(): Internal.Set<string>;
        onRemovedFromWorld(): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        handler$zzn002$onTick(arg0: Internal.CallbackInfo_): void;
        setYHeadRot(arg0: number): void;
        getLastAttacker(): Internal.LivingEntity;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getPercentFrozen(): number;
        getPickResult(): Internal.ItemStack;
        getRandomY(): number;
        setPortalCooldown(arg0: number): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        emf$isInvisible(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        emf$isSprinting(): boolean;
        shouldBeSaved(): boolean;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        getViewXRot(arg0: number): number;
        canRiderInteract(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        setPose(arg0: Internal.Pose_): void;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        notifyAll(): void;
        getPassengersRidingOffset(): number;
        etf$getScoreboardTeam(): Internal.Team;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tdv$getDynamicLightY(): number;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        "getServer()"(): Internal.MinecraftServer;
        setYRot(arg0: number): void;
        isFrame(): boolean;
        discard(): void;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        onClientRemoval(): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        setNoGravity(arg0: boolean): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        setRotation(yaw: number, pitch: number): void;
        createCommandSourceStack(): Internal.CommandSourceStack;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        getHorizontalFacing(): Internal.Direction;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        setId(arg0: number): void;
        getType(): string;
        getLightProbePosition(arg0: number): Vec3d;
        onAboveBubbleCol(arg0: boolean): void;
        emf$prevX(): number;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        checkDespawn(): void;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        static getViewScale(): number;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        canarySetClimbingMobCachingSectionUpdateBehavior(arg0: boolean): void;
        getVisualRotationYInDegrees(): number;
        wait(arg0: number, arg1: number): void;
        isDiscrete(): boolean;
        getTeamColor(): number;
        setNbt(nbt: Internal.CompoundTag_): void;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        extinguish(): void;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        emf$prevY(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        isForcedVisible(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        emf$getTypeString(): string;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        tdv$lambdynlights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        isFullyFrozen(): boolean;
        runCommand(command: string): number;
        setSharedFlagOnFire(arg0: boolean): void;
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get XRot(): number
        get suppressingBounce(): boolean
        get blockZ(): number
        get silent(): boolean
        set culled(value: boolean)
        get pitch(): number
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get passengersAndSelf(): Internal.Stream<any>
        set maxUpStep(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        get visuallyCrawling(): boolean
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        get inWaterOrBubble(): boolean
        get persistentData(): Internal.CompoundTag
        get portalCooldown(): number
        get item(): Internal.ItemStack
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        get ignoringBlockTriggers(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        set level(arg0: Internal.Level_)
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get blockX(): number
        get encodeId(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get eyePosition(): Vec3d
        get eyeHeight(): number
        get yaw(): number
        set customNameVisible(arg0: boolean)
        set outOfCamera(value: boolean)
        get remainingFireTicks(): number
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        set chopData(arg0: Internal.SyncedChopData_)
        get forward(): Vec3d
        get maxFallDistance(): number
        get id(): number
        get ticksFrozen(): number
        get eyeY(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get descending(): boolean
        get chopData(): Internal.SyncedChopData
        get YHeadRot(): number
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get myRidingOffset(): number
        set deltaMovement(arg0: Vec3d_)
        get culled(): boolean
        get living(): boolean
        get x(): number
        get glowing(): boolean
        get vehicle(): boolean
        get attackable(): boolean
        get xaero_OPAC_deadPlayer(): Internal.UUID
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        get underWater(): boolean
        get swimHighSpeedSplashSound(): Internal.SoundEvent
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        set touchingWater(arg0: boolean)
        get onRails(): boolean
        get dimensionChangingDelay(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        set yaw(arg0: number)
        get pickRadius(): number
        get firstTick(): boolean
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        set xaero_OPAC_deadPlayer(arg0: Internal.UUID_)
        get stringUuid(): string
        get removed(): boolean
        set swimming(arg0: boolean)
        get rotationVector(): Internal.Vec2
        get sprinting(): boolean
        get motionY(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get firstPassenger(): Internal.Entity
        get addedToWorld(): boolean
        set XRot(arg0: number)
        get soundSource(): Internal.SoundSource
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get pose(): Internal.Pose
        get lookAngle(): Vec3d
        get motionZ(): number
        set xaero_OPAC_lastChunkEntryDimension(arg0: Internal.ResourceKey_<any>)
        get invisible(): boolean
        set z(z: number)
        get y(): number
        get profile(): Internal.GameProfile
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get outOfCamera(): boolean
        get airSupply(): number
        get crouching(): boolean
        get animal(): boolean
        get player(): boolean
        get motionDirection(): Internal.Direction
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        set xaero_OPAC_lootOwner(arg0: Internal.UUID_)
        set alcohol(alcoholLevel: Internal.AlcoholLevel_)
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get maxAirSupply(): number
        get visuallySwimming(): boolean
        get facing(): Internal.Direction
        get swimming(): boolean
        get boundingBoxForCulling(): Internal.AABB
        get target(): Internal.LivingEntity
        set sprinting(arg0: boolean)
        set x(x: number)
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get portalWaitTime(): number
        get inWater(): boolean
        get blockStateOn(): Internal.BlockState
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get rootVehicle(): Internal.Entity
        get onPos(): BlockPos
        get noGravity(): boolean
        get stepHeight(): number
        get xaero_OPAC_lastChunkEntryDimension(): Internal.ResourceKey<any>
        get xaero_OPAC_lootOwner(): Internal.UUID
        set remainingFireTicks(arg0: number)
        get cachedFeetBlockState(): Internal.BlockState
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        get uuid(): Internal.UUID
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        set silent(arg0: boolean)
        get swimSplashSound(): Internal.SoundEvent
        get onPortalCooldown(): boolean
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get alwaysTicking(): boolean
        get bbWidth(): number
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get alcohol(): Internal.AlcoholLevel
        get "name()"(): net.minecraft.network.chat.Component
        get inFluidType(): boolean
        get ticksRequiredToFreeze(): number
        set glowing(arg0: boolean)
        get YRot(): number
        get alive(): boolean
        get bbHeight(): number
        get username(): string
        get tags(): Internal.Set<string>
        get pickable(): boolean
        set YHeadRot(arg0: number)
        get lastAttacker(): Internal.LivingEntity
        get percentFrozen(): number
        get pickResult(): Internal.ItemStack
        get randomY(): number
        set portalCooldown(arg0: number)
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set pose(arg0: Internal.Pose_)
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        get passengersRidingOffset(): number
        get "server()"(): Internal.MinecraftServer
        set YRot(arg0: number)
        get frame(): boolean
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set noGravity(arg0: boolean)
        get indirectPassengers(): Internal.Iterable<any>
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get passenger(): boolean
        get viewScale(): number
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get visualRotationYInDegrees(): number
        get discrete(): boolean
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get forcedVisible(): boolean
        get freezing(): boolean
        get fullyFrozen(): boolean
        set sharedFlagOnFire(arg0: boolean)
    }
    type Interaction_ = Interaction;
    interface WindowEventHandler {
        abstract setWindowActive(arg0: boolean): void;
        abstract cursorEntered(): void;
        abstract resizeDisplay(): void;
        set windowActive(arg0: boolean)
    }
    type WindowEventHandler_ = WindowEventHandler;
    abstract class ItemCore extends Internal.Item implements Internal.IWandCore {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        abstract getColor(): number;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        abstract getWandAction(): Internal.IWandAction;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        abstract getRegistryName(): ResourceLocation;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set burnTime(i: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        get color(): number
        get wandAction(): Internal.IWandAction
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        get registryName(): ResourceLocation
    }
    type ItemCore_ = ItemCore;
    class JumpControl implements Internal.Control {
        constructor(arg0: Internal.Mob_)
        getClass(): typeof any;
        jump(): void;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        tick(): void;
        get class(): typeof any
    }
    type JumpControl_ = JumpControl;
    interface IModLanguageProvider {
        abstract name(): string;
        abstract getFileVisitor(): Internal.Consumer<Internal.ModFileScanData>;
        abstract consumeLifecycleEvent<R extends Internal.ILifecycleEvent<R>>(arg0: Internal.Supplier_<R>): void;
        get fileVisitor(): Internal.Consumer<Internal.ModFileScanData>
    }
    type IModLanguageProvider_ = IModLanguageProvider;
    class ExportScreen extends Internal.GuiSettings {
        constructor(arg0: Internal.Screen_, arg1: Internal.Screen_, arg2: Internal.MapProcessor_, arg3: Internal.MapTileSelection_)
        charTyped(arg0: string, arg1: number): boolean;
        onFilesDrop(arg0: Internal.List_<Internal.Path>): void;
        "setFocused(net.minecraft.client.gui.components.events.GuiEventListener)"(arg0: Internal.GuiEventListener_): void;
        narrationEnabled(): void;
        setFocused(arg0: boolean): void;
        renderDirtBackground(arg0: Internal.GuiGraphics_): void;
        setTooltipForNextRenderPass(arg0: Internal.List_<Internal.FormattedCharSequence>): void;
        mouseClicked(arg0: number, arg1: number, arg2: number): boolean;
        renderWithTooltip(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        keyReleased(arg0: number, arg1: number, arg2: number): boolean;
        static isCut(arg0: number): boolean;
        handler$cnk000$drawScreen(guiGraphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, delta: number, ci: Internal.CallbackInfo_): void;
        getEntriesCopy(): any[];
        addRenderableWidget<T extends Internal.GuiEventListener & Internal.Renderable & Internal.NarratableEntry>(arg0: T): T;
        getChildrenKonkrete(): Internal.List<any>;
        getFocused(): Internal.GuiEventListener;
        "setTooltipForNextRenderPass(java.util.List,net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner,boolean)"(arg0: Internal.List_<Internal.FormattedCharSequence>, arg1: Internal.ClientTooltipPositioner_, arg2: boolean): void;
        nextFocusPath(arg0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        onDropdownClosed(arg0: xaero.map.gui.dropdown.DropDownWidget_): void;
        setFontKonkrete(arg0: net.minecraft.client.gui.Font_): void;
        handleComponentClicked(arg0: Internal.Style_): boolean;
        keyPressed(arg0: number, arg1: number, arg2: number): boolean;
        static findNarratableWidget(arg0: Internal.List_<Internal.NarratableEntry>, arg1: Internal.NarratableEntry_): Internal.Screen$NarratableSearchResult;
        controlling$getRenderables(): Internal.List<any>;
        removed(): void;
        children(): Internal.List<Internal.GuiEventListener>;
        render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        addRenderableOnly<T extends Internal.Renderable>(arg0: T): T;
        static isSelectAll(arg0: number): boolean;
        isDragging(): boolean;
        getChildAt(arg0: number, arg1: number): Optional<Internal.GuiEventListener>;
        shouldCloseOnEsc(): boolean;
        getClass(): typeof any;
        isFocused(): boolean;
        balm_getRenderables(): Internal.List<any>;
        getTabOrderGroup(): number;
        setFocused(arg0: Internal.GuiEventListener_): void;
        getRenderables(): Internal.List<any>;
        init(arg0: Internal.Minecraft_, arg1: number, arg2: number): void;
        getBackgroundMusic(): Internal.Music;
        getNarrationMessage(): net.minecraft.network.chat.Component;
        getRenderablesKonkrete(): Internal.List<any>;
        toString(): string;
        notifyAll(): void;
        static isPaste(arg0: number): boolean;
        afterKeyboardAction(): void;
        static hasControlDown(): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        replaceWidget(arg0: Internal.AbstractWidget_, arg1: Internal.AbstractWidget_): void;
        balm_getChildren(): Internal.List<any>;
        wait(arg0: number): void;
        static wrapScreenError(arg0: Internal.Runnable_, arg1: string, arg2: string): void;
        renderEscapeScreen(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        afterMouseAction(): void;
        getMinecraft(): Internal.Minecraft;
        onDropdownOpen(arg0: xaero.map.gui.dropdown.DropDownWidget_): void;
        static getTooltipFromItem(arg0: Internal.Minecraft_, arg1: Internal.ItemStack_): Internal.List<net.minecraft.network.chat.Component>;
        m_7856_(): void;
        notify(): void;
        getSelection(): Internal.MapTileSelection;
        afterMouseMove(): void;
        mouseMoved(arg0: number, arg1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        static isCopy(arg0: number): boolean;
        magicalSpecialHackyFocus(arg0: Internal.GuiEventListener_): void;
        tick(): void;
        isPauseScreen(): boolean;
        getEscape(): Internal.Screen;
        setDragging(arg0: boolean): void;
        wait(): void;
        getTitle(): net.minecraft.network.chat.Component;
        isMouseOver(arg0: number, arg1: number): boolean;
        getNarratables(): Internal.List<any>;
        static hasAltDown(): boolean;
        renderBackground(arg0: Internal.GuiGraphics_): void;
        mouseScrolled(arg0: number, arg1: number, arg2: number): boolean;
        restoreFocus(arg0: number): void;
        wait(arg0: number, arg1: number): void;
        onClose(): void;
        addWidget<T extends Internal.GuiEventListener & Internal.NarratableEntry>(arg0: T): T;
        static hasShiftDown(): boolean;
        balm_getNarratables(): Internal.List<any>;
        mouseDragged(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        replaceRenderableWidget(arg0: Internal.AbstractWidget_, arg1: Internal.AbstractWidget_): void;
        "setTooltipForNextRenderPass(net.minecraft.client.gui.components.Tooltip,net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner,boolean)"(arg0: Internal.Tooltip_, arg1: Internal.ClientTooltipPositioner_, arg2: boolean): void;
        onExportDone(arg0: Internal.PNGExportResult_): void;
        mouseReleased(arg0: number, arg1: number, arg2: number): boolean;
        resize(arg0: Internal.Minecraft_, arg1: number, arg2: number): void;
        "setFocused(boolean)"(arg0: boolean): void;
        setTooltipForNextRenderPass(arg0: Internal.List_<Internal.FormattedCharSequence>, arg1: Internal.ClientTooltipPositioner_, arg2: boolean): void;
        getIndex(arg0: Internal.GuiEventListener_): number;
        hashCode(): number;
        shouldSkipWorldRender(): boolean;
        added(): void;
        handleDelayedNarration(): void;
        equals(arg0: any): boolean;
        triggerImmediateNarration(arg0: boolean): void;
        redirect$cpl001$settingListToRenderRedirect(instance: Internal.ArrayList_<any>, entryObject: any): boolean;
        setTooltipForNextRenderPass(arg0: Internal.Tooltip_, arg1: Internal.ClientTooltipPositioner_, arg2: boolean): void;
        set "focused(net.minecraft.client.gui.components.events.GuiEventListener)"(arg0: Internal.GuiEventListener_)
        set focused(arg0: boolean)
        set tooltipForNextRenderPass(arg0: Internal.List_<Internal.FormattedCharSequence>)
        get entriesCopy(): any[]
        get childrenKonkrete(): Internal.List<any>
        get focused(): Internal.GuiEventListener
        set fontKonkrete(arg0: net.minecraft.client.gui.Font_)
        get dragging(): boolean
        get class(): typeof any
        get focused(): boolean
        get tabOrderGroup(): number
        set focused(arg0: Internal.GuiEventListener_)
        get renderables(): Internal.List<any>
        get backgroundMusic(): Internal.Music
        get narrationMessage(): net.minecraft.network.chat.Component
        get renderablesKonkrete(): Internal.List<any>
        get currentFocusPath(): Internal.ComponentPath
        get minecraft(): Internal.Minecraft
        get selection(): Internal.MapTileSelection
        get rectangle(): Internal.ScreenRectangle
        get pauseScreen(): boolean
        get escape(): Internal.Screen
        set dragging(arg0: boolean)
        get title(): net.minecraft.network.chat.Component
        get narratables(): Internal.List<any>
        set "focused(boolean)"(arg0: boolean)
        fullExport: boolean;
    }
    type ExportScreen_ = ExportScreen;
    interface Serializer <T> {
        abstract serialize(arg0: Internal.JsonObject_, arg1: T, arg2: Internal.JsonSerializationContext_): void;
        abstract deserialize(arg0: Internal.JsonObject_, arg1: Internal.JsonDeserializationContext_): T;
    }
    type Serializer_<T> = Serializer<T>;
    class Thread implements Internal.Runnable {
        constructor()
        constructor(arg0: Internal.ThreadGroup_, arg1: Internal.Runnable_, arg2: string)
        constructor(arg0: Internal.Runnable_)
        constructor(arg0: Internal.ThreadGroup_, arg1: Internal.Runnable_)
        constructor(arg0: Internal.ThreadGroup_, arg1: Internal.Runnable_, arg2: string, arg3: number, arg4: boolean)
        constructor(arg0: Internal.Runnable_, arg1: string)
        constructor(arg0: Internal.ThreadGroup_, arg1: string)
        constructor(arg0: Internal.ThreadGroup_, arg1: Internal.Runnable_, arg2: string, arg3: number)
        constructor(arg0: string)
        setUncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_): void;
        static "yield"(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        checkAccess(): void;
        isInterrupted(): boolean;
        notify(): void;
        static onSpinWait(): void;
        join(arg0: number): void;
        setName(arg0: string): void;
        isAlive(): boolean;
        static sleep(arg0: number): void;
        getContextClassLoader(): Internal.ClassLoader;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        resume(): void;
        getUncaughtExceptionHandler(): Internal.Thread$UncaughtExceptionHandler;
        getState(): Internal.Thread$State;
        static getDefaultUncaughtExceptionHandler(): Internal.Thread$UncaughtExceptionHandler;
        getStackTrace(): Internal.StackTraceElement[];
        setDaemon(arg0: boolean): void;
        start(): void;
        getPriority(): number;
        static interrupted(): boolean;
        wait(): void;
        /**
         * @deprecated
        */
        stop(): void;
        static activeCount(): number;
        join(): void;
        isDaemon(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        suspend(): void;
        getClass(): typeof any;
        static dumpStack(): void;
        run(): void;
        static sleep(arg0: number, arg1: number): void;
        static holdsLock(arg0: any): boolean;
        wait(arg0: number, arg1: number): void;
        static setDefaultUncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_): void;
        setContextClassLoader(arg0: Internal.ClassLoader_): void;
        getName(): string;
        getId(): number;
        getThreadGroup(): Internal.ThreadGroup;
        toString(): string;
        notifyAll(): void;
        static getAllStackTraces(): Internal.Map<Internal.Thread, Internal.StackTraceElement[]>;
        static currentThread(): Internal.Thread;
        setPriority(arg0: number): void;
        hashCode(): number;
        interrupt(): void;
        static enumerate(arg0: Internal.Thread_[]): number;
        wait(arg0: number): void;
        join(arg0: number, arg1: number): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        countStackFrames(): number;
        set uncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_)
        get interrupted(): boolean
        set name(arg0: string)
        get alive(): boolean
        get contextClassLoader(): Internal.ClassLoader
        get uncaughtExceptionHandler(): Internal.Thread$UncaughtExceptionHandler
        get state(): Internal.Thread$State
        get defaultUncaughtExceptionHandler(): Internal.Thread$UncaughtExceptionHandler
        get stackTrace(): Internal.StackTraceElement[]
        set daemon(arg0: boolean)
        get priority(): number
        get daemon(): boolean
        get class(): typeof any
        set defaultUncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_)
        set contextClassLoader(arg0: Internal.ClassLoader_)
        get name(): string
        get id(): number
        get threadGroup(): Internal.ThreadGroup
        get allStackTraces(): Internal.Map<Internal.Thread, Internal.StackTraceElement[]>
        set priority(arg0: number)
        static readonly MAX_PRIORITY: (10) & (number);
        static readonly NORM_PRIORITY: (5) & (number);
        static readonly MIN_PRIORITY: (1) & (number);
    }
    type Thread_ = Thread;
    class SkullBlockEntity extends Internal.BlockEntity implements Internal.ETFPlayerEntity {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        tdv$getDynamicLightWorld(): Internal.Level;
        emf$getVelocity(): Vec3d;
        etf$getType(): Internal.EntityType<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        load(arg0: Internal.CompoundTag_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        etf$writeNbt(compound: Internal.CompoundTag_): Internal.CompoundTag;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        isOutOfCamera(): boolean;
        tdv$getDynamicLightX(): number;
        emf$prevZ(): number;
        getOwnerProfile(): Internal.GameProfile;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        tdv$getLuminance(): number;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        emf$isSprinting(): boolean;
        etf$distanceTo(entity: Internal.Entity_): number;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        tdv$shouldUpdateDynamicLight(): boolean;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(arg0: Internal.Direction_, arg1: number): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        tdv$dynamicLightTick(): void;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        getNoteBlockSound(): ResourceLocation;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        tdv$lambdynlights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        etf$getEntity(): Internal.Entity;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        tdv$getDynamicLightY(): number;
        setWorldPosition(arg0: BlockPos_): void;
        static clear(): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        emf$getYaw(): number;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        tdv$resetDynamicLight(): void;
        getBlockPos(): BlockPos;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        etf$getBlockY(): number;
        etf$getHandItems(): Internal.Iterable<any>;
        getAnimation(arg0: number): number;
        emf$getY(): number;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        tdv$getDynamicLightZ(): number;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        static setup(arg0: Internal.Services_, arg1: Internal.Executor_): void;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        static animation(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.SkullBlockEntity_): void;
        setOutOfCamera(value: boolean): void;
        tdv$isDynamicLightEnabled(): boolean;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onlyOpCanSetNbt(): boolean;
        serializeNBT(): Internal.Tag;
        setOwner(arg0: Internal.GameProfile_): void;
        tdv$setDynamicLightEnabled(arg0: boolean): void;
        etf$isTeammate(player: Internal.Player_): boolean;
        etf$getName(): net.minecraft.network.chat.Component;
        saveWithFullMetadata(): Internal.CompoundTag;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        etf$isPartVisible(part: Internal.PlayerModelPart_): boolean;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        etf$getUuid(): Internal.UUID;
        static updateGameprofile(arg0: Internal.GameProfile_, arg1: Internal.Consumer_<Internal.GameProfile>): void;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        etf$getUuidAsString(): string;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        etf$getInventory(): Internal.Inventory;
        tdv$lambdynlights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get outOfCamera(): boolean
        get ownerProfile(): Internal.GameProfile
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get updatePacket(): Internal.Packet<any>
        get persistentData(): Internal.CompoundTag
        get noteBlockSound(): ResourceLocation
        set worldPosition(arg0: BlockPos_)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        set owner(arg0: Internal.GameProfile_)
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
        static readonly TAG_NOTE_BLOCK_SOUND: ("note_block_sound") & (string);
        static readonly TAG_SKULL_OWNER: ("SkullOwner") & (string);
    }
    type SkullBlockEntity_ = SkullBlockEntity;
    interface ItemBuilder$UseCallback {
        abstract use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): boolean;
        (arg0: Internal.Level, arg1: Internal.Player, arg2: Internal.InteractionHand): boolean;
    }
    type ItemBuilder$UseCallback_ = ((arg0: Internal.Level, arg1: Internal.Player, arg2: Internal.InteractionHand)=> boolean) | ItemBuilder$UseCallback;
    class CyanSkirtItem$Boots extends Internal.CyanSkirtItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type CyanSkirtItem$Boots_ = CyanSkirtItem$Boots;
    class EntityRenderDispatcher implements Internal.ResourceManagerReloadListener, Internal.EntityRenderDispatcherAccessor {
        constructor(arg0: Internal.Minecraft_, arg1: Internal.TextureManager_, arg2: Internal.ItemRenderer_, arg3: Internal.BlockRenderDispatcher_, arg4: net.minecraft.client.gui.Font_, arg5: Internal.Options_, arg6: Internal.EntityModelSet_)
        getClass(): typeof any;
        distanceToSqr(arg0: Internal.Entity_): number;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        overrideCameraOrientation(arg0: Quaternionf_): void;
        wait(arg0: number, arg1: number): void;
        isRenderShadows(): boolean;
        getRenderer<T extends Internal.Entity>(arg0: T): Internal.EntityRenderer<T>;
        cameraOrientation(): Quaternionf;
        setRenderHitBoxes(arg0: boolean): void;
        getName(): string;
        getSkinMap(): Internal.Map<string, Internal.EntityRenderer<Internal.Player>>;
        prepare(arg0: Internal.Level_, arg1: Internal.Camera_, arg2: Internal.Entity_): void;
        shouldRender<E extends Internal.Entity>(arg0: E, arg1: Internal.Frustum_, arg2: number, arg3: number, arg4: number): boolean;
        reload(arg0: Internal.PreparableReloadListener$PreparationBarrier_, arg1: Internal.ResourceManager_, arg2: Internal.ProfilerFiller_, arg3: Internal.ProfilerFiller_, arg4: Internal.Executor_, arg5: Internal.Executor_): Internal.CompletableFuture<void>;
        toString(): string;
        render<E extends Internal.Entity>(arg0: E, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.PoseStack_, arg7: Internal.MultiBufferSource_, arg8: number): void;
        notifyAll(): void;
        onResourceManagerReload(arg0: Internal.ResourceManager_): void;
        getPackedLightCoords<E extends Internal.Entity>(arg0: E, arg1: number): number;
        hashCode(): number;
        shouldRenderHitBoxes(): boolean;
        getItemInHandRenderer(): Internal.ItemInHandRenderer;
        setRenderShadow(arg0: boolean): void;
        wait(): void;
        wait(arg0: number): void;
        distanceToSqr(arg0: number, arg1: number, arg2: number): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        set level(arg0: Internal.Level_)
        get renderShadows(): boolean
        set renderHitBoxes(arg0: boolean)
        get name(): string
        get skinMap(): Internal.Map<string, Internal.EntityRenderer<Internal.Player>>
        get itemInHandRenderer(): Internal.ItemInHandRenderer
        set renderShadow(arg0: boolean)
        crosshairPickEntity: Internal.Entity;
        camera: Internal.Camera;
        readonly textureManager: Internal.TextureManager;
        readonly options: Internal.Options;
        renderers: Internal.Map<Internal.EntityType<any>, Internal.EntityRenderer<any>>;
    }
    type EntityRenderDispatcher_ = EntityRenderDispatcher;
    class BranchTextureRenderer {
        constructor()
        render(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.RenderTarget_, arg6: boolean): void;
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type BranchTextureRenderer_ = BranchTextureRenderer;
    abstract class SyncedBlockEntity extends Internal.BlockEntity {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        tdv$getDynamicLightWorld(): Internal.Level;
        emf$getVelocity(): Vec3d;
        etf$getType(): Internal.EntityType<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        readClient(arg0: Internal.CompoundTag_): void;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        load(arg0: Internal.CompoundTag_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        etf$writeNbt(compound: Internal.CompoundTag_): Internal.CompoundTag;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        tdv$getDynamicLightX(): number;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        tdv$getLuminance(): number;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        emf$isSprinting(): boolean;
        etf$distanceTo(entity: Internal.Entity_): number;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        tdv$shouldUpdateDynamicLight(): boolean;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(arg0: Internal.Direction_, arg1: number): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        tdv$dynamicLightTick(): void;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        tdv$lambdynlights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        tdv$getDynamicLightY(): number;
        setWorldPosition(arg0: BlockPos_): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        sendData(): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        emf$getYaw(): number;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        tdv$resetDynamicLight(): void;
        getBlockPos(): BlockPos;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        etf$getBlockY(): number;
        etf$getHandItems(): Internal.Iterable<any>;
        emf$getY(): number;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        tdv$getDynamicLightZ(): number;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        notifyUpdate(): void;
        setOutOfCamera(value: boolean): void;
        tdv$isDynamicLightEnabled(): boolean;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onlyOpCanSetNbt(): boolean;
        serializeNBT(): Internal.Tag;
        tdv$setDynamicLightEnabled(arg0: boolean): void;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        etf$getUuid(): Internal.UUID;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        tdv$lambdynlights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get updatePacket(): Internal.Packet<any>
        get persistentData(): Internal.CompoundTag
        set worldPosition(arg0: BlockPos_)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type SyncedBlockEntity_ = SyncedBlockEntity;
    abstract class CatEarsGreyItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type CatEarsGreyItem_ = CatEarsGreyItem;
    class ItemOverride {
        constructor(arg0: ResourceLocation_, arg1: Internal.List_<Internal.ItemOverride$Predicate>)
        getClass(): typeof any;
        hashCode(): number;
        getModel(): ResourceLocation;
        toString(): string;
        wait(): void;
        getPredicates(): Internal.Stream<Internal.ItemOverride$Predicate>;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        get model(): ResourceLocation
        get predicates(): Internal.Stream<Internal.ItemOverride$Predicate>
    }
    type ItemOverride_ = ItemOverride;
    class RodBlock extends Internal.DirectionalBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type RodBlock_ = RodBlock;
    interface EventHandlerImplCommon$LevelEventAttachment {
        abstract architectury$getAttachedLevel(): Internal.LevelAccessor;
        abstract architectury$attachLevel(arg0: Internal.LevelAccessor_): void;
    }
    type EventHandlerImplCommon$LevelEventAttachment_ = EventHandlerImplCommon$LevelEventAttachment;
    class CeilingHangingSignBlock extends Internal.SignBlock implements Internal.EntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_, arg1: Internal.WoodType_)
        getSignHitboxCenterPosition(arg0: Internal.BlockState_): Vec3d;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static getWoodType(arg0: Internal.Block_): Internal.WoodType;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        openTextEdit(arg0: Internal.Player_, arg1: Internal.SignBlockEntity_, arg2: boolean): void;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        getYRotationDegrees(arg0: Internal.BlockState_): number;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        handler$ejn000$amendments$use(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        getPickupSound(arg0: Internal.BlockState_): Optional<Internal.SoundEvent>;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        type(): Internal.WoodType;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        getTicker(pLevel: Internal.Level_, pState: Internal.BlockState_, pBlockEntityType: Internal.BlockEntityType_<any>): Internal.BlockEntityTicker<any>;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, placer: Internal.LivingEntity_, stack: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        handler$ejn000$amendments$updateExtension(state: Internal.BlockState_, direction: Internal.Direction_, neighborState: Internal.BlockState_, level: Internal.LevelAccessor_, currentPos: BlockPos_, neighborPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly ROTATION: (Internal.IntegerProperty) & (Internal.IntegerProperty);
        static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type CeilingHangingSignBlock_ = CeilingHangingSignBlock;
    class ColorProperty extends Internal.Enum<Internal.ColorProperty> implements Internal.StringRepresentable {
        getClass(): typeof any;
        compareTo(arg0: Internal.ColorProperty_): number;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static fromSheet(sheet: Internal.Item_): Internal.ColorProperty;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        toCushion(): Internal.ItemStack;
        static fromCushion(cushion: Internal.Item_): Internal.ColorProperty;
        "compareTo(earth.terrarium.handcrafted.common.blocks.base.properties.ColorProperty)"(arg0: Internal.ColorProperty_): number;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.ColorProperty>>;
        static valueOf(name: string): Internal.ColorProperty;
        toString(): string;
        notifyAll(): void;
        name(): string;
        hashCode(): number;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        ordinal(): number;
        wait(): void;
        getDeclaringClass(): typeof Internal.ColorProperty;
        static values(): Internal.ColorProperty[];
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        toSheet(): Internal.ItemStack;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.ColorProperty
        static readonly CYAN: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly BROWN: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly PURPLE: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly BLUE: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly WHITE: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly ORANGE: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly BLACK: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly YELLOW: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly GREEN: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly MAGENTA: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly LIME: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly GRAY: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly LIGHT_BLUE: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly LIGHT_GRAY: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly PINK: (Internal.ColorProperty) & (Internal.ColorProperty);
        static readonly RED: (Internal.ColorProperty) & (Internal.ColorProperty);
    }
    type ColorProperty_ = "light_blue" | "magenta" | "lime" | "brown" | "red" | "purple" | "pink" | "black" | "green" | "cyan" | "light_gray" | "yellow" | "white" | "gray" | "blue" | "orange" | ColorProperty;
    class MemoryModuleType <U> {
        constructor(arg0: Optional_<Internal.Codec<U>>)
        getClass(): typeof any;
        getCodec(): Optional<Internal.Codec<Internal.ExpirableValue<U>>>;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        get codec(): Optional<Internal.Codec<Internal.ExpirableValue<U>>>
        static readonly HUNTED_RECENTLY: Internal.MemoryModuleType<boolean>;
        static readonly INTERACTION_TARGET: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly ADMIRING_DISABLED: Internal.MemoryModuleType<boolean>;
        static readonly RECENT_PROJECTILE: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly SNIFFER_EXPLORED_POSITIONS: Internal.MemoryModuleType<Internal.List<Internal.GlobalPos>>;
        static readonly SECONDARY_JOB_SITE: Internal.MemoryModuleType<Internal.List<Internal.GlobalPos>>;
        static readonly LAST_SLEPT: Internal.MemoryModuleType<number>;
        static readonly IS_PREGNANT: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly RAM_TARGET: Internal.MemoryModuleType<Vec3d>;
        static readonly NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD: Internal.MemoryModuleType<Internal.Player>;
        static readonly HURT_BY: Internal.MemoryModuleType<DamageSource>;
        static readonly HAS_HUNTING_COOLDOWN: Internal.MemoryModuleType<boolean>;
        static readonly ATTACK_COOLING_DOWN: Internal.MemoryModuleType<boolean>;
        static readonly JOB_SITE: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly UNIVERSAL_ANGER: Internal.MemoryModuleType<boolean>;
        static readonly ITEM_PICKUP_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly NEAREST_PLAYERS: Internal.MemoryModuleType<Internal.List<Internal.Player>>;
        static readonly IS_IN_WATER: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly RAM_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly NEAREST_VISIBLE_NEMESIS: Internal.MemoryModuleType<Internal.Mob>;
        static readonly VISIBLE_ADULT_HOGLIN_COUNT: Internal.MemoryModuleType<number>;
        static readonly HOME: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly TIME_TRYING_TO_REACH_ADMIRE_ITEM: Internal.MemoryModuleType<number>;
        static readonly HEARD_BELL_TIME: Internal.MemoryModuleType<number>;
        static readonly GAZE_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly LAST_WOKEN: Internal.MemoryModuleType<number>;
        static readonly VIBRATION_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly NEAREST_REPELLENT: Internal.MemoryModuleType<BlockPos>;
        static readonly LOOK_TARGET: Internal.MemoryModuleType<Internal.PositionTracker>;
        static readonly NEAREST_BED: Internal.MemoryModuleType<BlockPos>;
        static readonly ROAR_TARGET: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly NEAREST_VISIBLE_ADULT: Internal.MemoryModuleType<Internal.AgeableMob>;
        static readonly DISTURBANCE_LOCATION: Internal.MemoryModuleType<BlockPos>;
        static readonly ATE_RECENTLY: Internal.MemoryModuleType<boolean>;
        static readonly LIKED_NOTEBLOCK_POSITION: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly CELEBRATE_LOCATION: Internal.MemoryModuleType<BlockPos>;
        static readonly NEAREST_VISIBLE_ADULT_PIGLINS: Internal.MemoryModuleType<Internal.List<Internal.AbstractPiglin>>;
        static readonly SNIFFER_HAPPY: Internal.MemoryModuleType<boolean>;
        static readonly NEAREST_VISIBLE_HUNTABLE_HOGLIN: Internal.MemoryModuleType<Internal.Hoglin>;
        static readonly NEAREST_VISIBLE_PLAYER: Internal.MemoryModuleType<Internal.Player>;
        static readonly LIKED_PLAYER: Internal.MemoryModuleType<Internal.UUID>;
        static readonly IS_EMERGING: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly DISABLE_WALK_TO_ADMIRE_ITEM: Internal.MemoryModuleType<boolean>;
        static readonly HURT_BY_ENTITY: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly IS_TEMPTED: Internal.MemoryModuleType<boolean>;
        static readonly NEAREST_PLAYER_HOLDING_WANTED_ITEM: Internal.MemoryModuleType<Internal.Player>;
        static readonly NEAREST_HOSTILE: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly DIG_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly SONIC_BOOM_SOUND_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly GOLEM_DETECTED_RECENTLY: Internal.MemoryModuleType<boolean>;
        static readonly INTERACTABLE_DOORS: Internal.MemoryModuleType<Internal.List<Internal.GlobalPos>>;
        static readonly LAST_WORKED_AT_POI: Internal.MemoryModuleType<number>;
        static readonly WALK_TARGET: Internal.MemoryModuleType<Internal.WalkTarget>;
        static readonly PATH: Internal.MemoryModuleType<net.minecraft.world.level.pathfinder.Path>;
        static readonly NEAREST_VISIBLE_ADULT_PIGLIN: Internal.MemoryModuleType<Internal.AbstractPiglin>;
        static readonly DOORS_TO_CLOSE: Internal.MemoryModuleType<Internal.Set<Internal.GlobalPos>>;
        static readonly IS_PANICKING: Internal.MemoryModuleType<boolean>;
        static readonly NEAREST_VISIBLE_ATTACKABLE_PLAYER: Internal.MemoryModuleType<Internal.Player>;
        static readonly RIDE_TARGET: Internal.MemoryModuleType<Internal.Entity>;
        static readonly NEAREST_VISIBLE_ADULT_HOGLINS: Internal.MemoryModuleType<Internal.List<Internal.Hoglin>>;
        static readonly ROAR_SOUND_DELAY: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly ATTACK_TARGET: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly MEETING_POINT: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly ANGRY_AT: Internal.MemoryModuleType<Internal.UUID>;
        static readonly IS_SNIFFING: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly LONG_JUMP_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly SONIC_BOOM_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly BREED_TARGET: Internal.MemoryModuleType<Internal.AgeableMob>;
        static readonly NEAREST_LIVING_ENTITIES: Internal.MemoryModuleType<Internal.List<Internal.LivingEntity>>;
        static readonly DANCING: Internal.MemoryModuleType<boolean>;
        static readonly NEAREST_VISIBLE_WANTED_ITEM: Internal.MemoryModuleType<Internal.ItemEntity>;
        static readonly AVOID_TARGET: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly SNIFFER_SNIFFING_TARGET: Internal.MemoryModuleType<BlockPos>;
        static readonly NEAREST_ATTACKABLE: Internal.MemoryModuleType<Internal.LivingEntity>;
        static readonly SNIFFER_DIGGING: Internal.MemoryModuleType<boolean>;
        static readonly PLAY_DEAD_TICKS: Internal.MemoryModuleType<number>;
        static readonly CANT_REACH_WALK_TARGET_SINCE: Internal.MemoryModuleType<number>;
        static readonly POTENTIAL_JOB_SITE: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly HIDING_PLACE: Internal.MemoryModuleType<Internal.GlobalPos>;
        static readonly NEAREST_VISIBLE_LIVING_ENTITIES: Internal.MemoryModuleType<Internal.NearestVisibleLivingEntities>;
        static readonly TEMPTING_PLAYER: Internal.MemoryModuleType<Internal.Player>;
        static readonly DUMMY: Internal.MemoryModuleType<void>;
        static readonly ROAR_SOUND_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly UNREACHABLE_TONGUE_TARGETS: Internal.MemoryModuleType<Internal.List<Internal.UUID>>;
        static readonly ADMIRING_ITEM: Internal.MemoryModuleType<boolean>;
        static readonly VISIBLE_VILLAGER_BABIES: Internal.MemoryModuleType<Internal.List<Internal.LivingEntity>>;
        static readonly TEMPTATION_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly TOUCH_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly LIKED_NOTEBLOCK_COOLDOWN_TICKS: Internal.MemoryModuleType<number>;
        static readonly PACIFIED: Internal.MemoryModuleType<boolean>;
        static readonly VISIBLE_ADULT_PIGLIN_COUNT: Internal.MemoryModuleType<number>;
        static readonly NEAREST_VISIBLE_BABY_HOGLIN: Internal.MemoryModuleType<Internal.Hoglin>;
        static readonly LONG_JUMP_MID_JUMP: Internal.MemoryModuleType<boolean>;
        static readonly NEARBY_ADULT_PIGLINS: Internal.MemoryModuleType<Internal.List<Internal.AbstractPiglin>>;
        static readonly SONIC_BOOM_SOUND_DELAY: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly SNIFF_COOLDOWN: Internal.MemoryModuleType<net.minecraft.util.Unit>;
        static readonly NEAREST_VISIBLE_ZOMBIFIED: Internal.MemoryModuleType<Internal.LivingEntity>;
    }
    type MemoryModuleType_<U> = MemoryModuleType<U> | Special.MemoryModuleType;
    class GreySkirtItem$Leggings extends Internal.GreySkirtItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type GreySkirtItem$Leggings_ = GreySkirtItem$Leggings;
    abstract class BlockImitator extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        abstract getImitatedBlockState(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type BlockImitator_ = BlockImitator;
    class ScheduledEvents {
        constructor(factory: Internal.Supplier_<Internal.ScheduledEvents$ScheduledEvent>)
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        clear(id: number): void;
        schedule(timer: Internal.TemporalAmount_, repeating: boolean, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        tickAll(nowTicks: number): void;
        equals(arg0: any): boolean;
        schedule(timer: number, ofTicks: boolean, repeating: boolean, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        get class(): typeof any
        readonly nextId: Internal.AtomicInteger;
        currentTick: number;
        readonly factory: Internal.Supplier<Internal.ScheduledEvents$ScheduledEvent>;
        currentMillis: number;
        readonly futureEvents: Internal.LinkedList<Internal.ScheduledEvents$ScheduledEvent>;
        readonly events: Internal.LinkedList<Internal.ScheduledEvents$ScheduledEvent>;
    }
    type ScheduledEvents_ = ScheduledEvents;
    class SculkShriekerBlockEntity extends Internal.BlockEntity implements Internal.GameEventListener$Holder<Internal.VibrationSystem$Listener>, Internal.VibrationSystem {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        tdv$getDynamicLightWorld(): Internal.Level;
        emf$getVelocity(): Vec3d;
        etf$getType(): Internal.EntityType<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        load(arg0: Internal.CompoundTag_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        etf$writeNbt(compound: Internal.CompoundTag_): Internal.CompoundTag;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        static getResonanceEventByFrequency(arg0: number): Internal.GameEvent;
        isOutOfCamera(): boolean;
        tdv$getDynamicLightX(): number;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        tdv$getLuminance(): number;
        static getRedstoneStrengthForDistance(arg0: number, arg1: number): number;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        emf$isSprinting(): boolean;
        etf$distanceTo(entity: Internal.Entity_): number;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        tdv$shouldUpdateDynamicLight(): boolean;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(arg0: Internal.Direction_, arg1: number): void;
        getUpdatePacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        clearRemoved(): void;
        emf$isWet(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        tryRespond(arg0: Internal.ServerLevel_): void;
        tdv$dynamicLightTick(): void;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        tdv$lambdynlights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        getListener(): Internal.VibrationSystem$Listener;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        tdv$getDynamicLightY(): number;
        setWorldPosition(arg0: BlockPos_): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        tryShriek(arg0: Internal.ServerLevel_, arg1: Internal.ServerPlayer_): void;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        emf$getYaw(): number;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        tdv$resetDynamicLight(): void;
        getBlockPos(): BlockPos;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        etf$getBlockY(): number;
        etf$getHandItems(): Internal.Iterable<any>;
        emf$getY(): number;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        tdv$getDynamicLightZ(): number;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        static getGameEventFrequency(arg0: Internal.GameEvent_): number;
        setOutOfCamera(value: boolean): void;
        tdv$isDynamicLightEnabled(): boolean;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onlyOpCanSetNbt(): boolean;
        getVibrationUser(): Internal.VibrationSystem$User;
        serializeNBT(): Internal.Tag;
        tdv$setDynamicLightEnabled(arg0: boolean): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        etf$getUuid(): Internal.UUID;
        getVibrationData(): Internal.VibrationSystem$Data;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        static tryGetPlayer(arg0: Internal.Entity_): Internal.ServerPlayer;
        tdv$lambdynlights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get outOfCamera(): boolean
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get updatePacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get persistentData(): Internal.CompoundTag
        get listener(): Internal.VibrationSystem$Listener
        set worldPosition(arg0: BlockPos_)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get vibrationUser(): Internal.VibrationSystem$User
        get vibrationData(): Internal.VibrationSystem$Data
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type SculkShriekerBlockEntity_ = SculkShriekerBlockEntity;
    abstract class CharsetDecoder {
        getClass(): typeof any;
        replacement(): string;
        maxCharsPerByte(): number;
        averageCharsPerByte(): number;
        onMalformedInput(arg0: Internal.CodingErrorAction_): this;
        notify(): void;
        unmappableCharacterAction(): Internal.CodingErrorAction;
        wait(arg0: number, arg1: number): void;
        onUnmappableCharacter(arg0: Internal.CodingErrorAction_): this;
        decode(arg0: Internal.ByteBuffer_, arg1: Internal.CharBuffer_, arg2: boolean): Internal.CoderResult;
        malformedInputAction(): Internal.CodingErrorAction;
        reset(): this;
        isAutoDetecting(): boolean;
        toString(): string;
        charset(): Internal.Charset;
        notifyAll(): void;
        flush(arg0: Internal.CharBuffer_): Internal.CoderResult;
        replaceWith(arg0: string): this;
        detectedCharset(): Internal.Charset;
        decode(arg0: Internal.ByteBuffer_): Internal.CharBuffer;
        isCharsetDetected(): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get autoDetecting(): boolean
        get charsetDetected(): boolean
    }
    type CharsetDecoder_ = CharsetDecoder;
    class RotatedBlockProvider extends Internal.BlockStateProvider {
        constructor(arg0: Internal.Block_)
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static simple(arg0: Internal.Block_): Internal.SimpleStateProvider;
        hashCode(): number;
        static simple(arg0: Internal.BlockState_): Internal.SimpleStateProvider;
        wait(): void;
        static "simple(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): Internal.SimpleStateProvider;
        wait(arg0: number): void;
        getState(arg0: Internal.RandomSource_, arg1: BlockPos_): Internal.BlockState;
        equals(arg0: any): boolean;
        static "simple(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.SimpleStateProvider;
        get class(): typeof any
        static readonly CODEC: Internal.Codec<Internal.RotatedBlockProvider>;
    }
    type RotatedBlockProvider_ = RotatedBlockProvider;
    abstract class GreenPlaidSkirtItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type GreenPlaidSkirtItem_ = GreenPlaidSkirtItem;
    interface ShortIterable extends Internal.Iterable<number> {
        /**
         * @deprecated
        */
        "forEach(java.util.function.Consumer)"(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        iterator(): Internal.Iterator<any>;
        spliterator(): Internal.Spliterator<any>;
        "forEach(it.unimi.dsi.fastutil.shorts.ShortConsumer)"(arg0: Internal.ShortConsumer_): void;
        forEach(arg0: Internal.ShortConsumer_): void;
        forEach(arg0: Internal.IntConsumer_): void;
        "forEach(java.util.function.IntConsumer)"(arg0: Internal.IntConsumer_): void;
        intSpliterator(): Internal.IntSpliterator;
        intIterator(): Internal.IntIterator;
    }
    type ShortIterable_ = ShortIterable;
    class FortuneEffect extends Internal.MobEffect {
        constructor()
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(entity: Internal.LivingEntity_, amplifier: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type FortuneEffect_ = FortuneEffect;
    abstract class RenderElement implements Internal.ScreenElement {
        constructor()
        getClass(): typeof any;
        at<T extends Internal.RenderElement>(arg0: number, arg1: number, arg2: number): T;
        getX(): number;
        getZ(): number;
        toString(): string;
        getY(): number;
        render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number): void;
        getWidth(): number;
        withBounds<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        notifyAll(): void;
        abstract render(arg0: Internal.GuiGraphics_): void;
        withAlpha<T extends Internal.RenderElement>(arg0: number): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static of(arg0: Internal.ScreenElement_): Internal.RenderElement;
        at<T extends Internal.RenderElement>(arg0: number, arg1: number): T;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getHeight(): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get x(): number
        get z(): number
        get y(): number
        get width(): number
        get height(): number
        static readonly EMPTY: Internal.RenderElement;
    }
    type RenderElement_ = RenderElement;
    interface ICurioStacksHandler {
        abstract applySyncTag(arg0: Internal.CompoundTag_): void;
        abstract getCachedModifiers(): Internal.Set<Internal.AttributeModifier>;
        abstract getRenders(): Internal.NonNullList<boolean>;
        abstract removeModifier(arg0: Internal.UUID_): void;
        canToggleRendering(): boolean;
        abstract getCosmeticStacks(): Internal.IDynamicStackHandler;
        abstract getSlots(): number;
        /**
         * @deprecated
        */
        abstract shrink(arg0: number): void;
        abstract getModifiersByOperation(arg0: Internal.AttributeModifier$Operation_): Internal.Collection<Internal.AttributeModifier>;
        abstract addPermanentModifier(arg0: Internal.AttributeModifier_): void;
        abstract isVisible(): boolean;
        getDropRule(): Internal.ICurio$DropRule;
        abstract getIdentifier(): string;
        abstract clearCachedModifiers(): void;
        abstract getStacks(): Internal.IDynamicStackHandler;
        /**
         * @deprecated
        */
        abstract getSizeShift(): number;
        abstract getPermanentModifiers(): Internal.Set<Internal.AttributeModifier>;
        abstract hasCosmetic(): boolean;
        abstract serializeNBT(): Internal.CompoundTag;
        abstract copyModifiers(arg0: Internal.ICurioStacksHandler_): void;
        abstract deserializeNBT(arg0: Internal.CompoundTag_): void;
        abstract addTransientModifier(arg0: Internal.AttributeModifier_): void;
        abstract getSyncTag(): Internal.CompoundTag;
        abstract update(): void;
        abstract clearModifiers(): void;
        abstract getModifiers(): Internal.Map<Internal.UUID, Internal.AttributeModifier>;
        /**
         * @deprecated
        */
        abstract grow(arg0: number): void;
        get cachedModifiers(): Internal.Set<Internal.AttributeModifier>
        get renders(): Internal.NonNullList<boolean>
        get cosmeticStacks(): Internal.IDynamicStackHandler
        get slots(): number
        get visible(): boolean
        get dropRule(): Internal.ICurio$DropRule
        get identifier(): string
        get stacks(): Internal.IDynamicStackHandler
        /**
         * @deprecated
        */
        get sizeShift(): number
        get permanentModifiers(): Internal.Set<Internal.AttributeModifier>
        get syncTag(): Internal.CompoundTag
        get modifiers(): Internal.Map<Internal.UUID, Internal.AttributeModifier>
    }
    type ICurioStacksHandler_ = ICurioStacksHandler;
    abstract class RoyalTunicYellowItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type RoyalTunicYellowItem_ = RoyalTunicYellowItem;
    interface SecretKey extends Internal.Key, Internal.Destroyable {
        abstract getAlgorithm(): string;
        abstract getFormat(): string;
        destroy(): void;
        isDestroyed(): boolean;
        abstract getEncoded(): number[];
        get algorithm(): string
        get format(): string
        get destroyed(): boolean
        get encoded(): number[]
        /**
         * @deprecated
        */
        readonly serialVersionUID: (-4795878709595146952) & (number);
    }
    type SecretKey_ = SecretKey;
    class IntData implements Internal.IData {
        constructor(arg0: Internal.IntTag_)
        constructor(arg0: number)
        asShort(): number;
        asBool(): boolean;
        notify(): void;
        asString(): string;
        compareTo(arg0: any): number;
        accept<T>(arg0: Internal.DataVisitor_<T>): T;
        remove(arg0: number): void;
        asByte(): number;
        mul(arg0: Internal.IData_): Internal.IData;
        "remove(java.lang.String)"(arg0: string): void;
        "getAt(int)"(arg0: number): Internal.IData;
        asLong(): number;
        forEach(arg0: Internal.Consumer_<Internal.IData>): void;
        asInt(): number;
        containsList(arg0: Internal.List_<Internal.IData>): boolean;
        div(arg0: Internal.IData_): Internal.IData;
        length(): number;
        isMappable(): boolean;
        getInternal(): Internal.Tag;
        asFloat(): number;
        copy(): Internal.IData;
        getKeys(): Internal.Set<string>;
        spliterator(): Internal.Spliterator<Internal.IData>;
        wait(): void;
        asDouble(): number;
        getType(): Internal.IData$Type;
        remove(arg0: string): void;
        asByteArray(): number[];
        "compareTo(java.lang.Object)"(arg0: any): number;
        and(arg0: Internal.IData_): Internal.IData;
        getClass(): typeof any;
        add(arg0: Internal.IData_): Internal.IData;
        asIntArray(): number[];
        not(): Internal.IData;
        isEmpty(): boolean;
        merge(arg0: Internal.IData_): Internal.IData;
        mod(arg0: Internal.IData_): Internal.IData;
        equalTo(arg0: Internal.IData_): boolean;
        wait(arg0: number, arg1: number): void;
        asList(): Internal.List<Internal.IData>;
        shl(arg0: Internal.IData_): Internal.IData;
        getAt(arg0: string): Internal.IData;
        neg(): Internal.IData;
        getId(): number;
        static listOf(...arg0: Internal.IData_[]): Internal.IData;
        shr(arg0: Internal.IData_): Internal.IData;
        "remove(int)"(arg0: number): void;
        compareTo(arg0: Internal.IData_): number;
        contains(arg0: Internal.IData_): boolean;
        toString(): string;
        "compareTo(com.blamejared.crafttweaker.api.data.IData)"(arg0: Internal.IData_): number;
        put(arg0: string, arg1: Internal.IData_): void;
        setAt(arg0: string, arg1: Internal.IData_): void;
        sub(arg0: Internal.IData_): Internal.IData;
        notifyAll(): void;
        copyInternal(): Internal.IData;
        or(arg0: Internal.IData_): Internal.IData;
        cat(arg0: Internal.IData_): Internal.IData;
        isListable(): boolean;
        hashCode(): number;
        getAsString(): string;
        iterator(): Internal.Iterator<Internal.IData>;
        map(arg0: Internal.Function_<Internal.IData, Internal.IData>): Internal.IData;
        "getAt(java.lang.String)"(arg0: string): Internal.IData;
        xor(arg0: Internal.IData_): Internal.IData;
        asLongArray(): number[];
        wait(arg0: number): void;
        getAt(arg0: number): Internal.IData;
        asMap(): Internal.Map<string, Internal.IData>;
        equals(arg0: any): boolean;
        get mappable(): boolean
        get internal(): Internal.Tag
        get keys(): Internal.Set<string>
        get type(): Internal.IData$Type
        get class(): typeof any
        get empty(): boolean
        get id(): number
        get listable(): boolean
        get asString(): string
    }
    type IntData_ = IntData;
    class CrashReport {
        constructor(arg0: string, arg1: Internal.Throwable_)
        getClass(): typeof any;
        static preload(): void;
        getException(): Internal.Throwable;
        getTitle(): string;
        toString(): string;
        static forThrowable(arg0: Internal.Throwable_, arg1: string): Internal.CrashReport;
        saveToFile(arg0: Internal.File_): boolean;
        notifyAll(): void;
        getSystemReport(): Internal.SystemReport;
        getDetails(arg0: Internal.StringBuilder_): void;
        getExceptionMessage(): string;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getFriendlyReport(): string;
        addCategory(arg0: string): Internal.CrashReportCategory;
        hashCode(): number;
        getSaveFile(): Internal.File;
        wait(): void;
        wait(arg0: number): void;
        addCategory(arg0: string, arg1: number): Internal.CrashReportCategory;
        equals(arg0: any): boolean;
        getDetails(): string;
        get class(): typeof any
        get exception(): Internal.Throwable
        get title(): string
        get systemReport(): Internal.SystemReport
        get exceptionMessage(): string
        get friendlyReport(): string
        get saveFile(): Internal.File
        get details(): string
    }
    type CrashReport_ = CrashReport;
    interface StructurePieceAccessor {
        abstract addPiece(arg0: Internal.StructurePiece_): void;
        abstract findCollisionPiece(arg0: Internal.BoundingBox_): Internal.StructurePiece;
    }
    type StructurePieceAccessor_ = StructurePieceAccessor;
    interface RandomGenerator {
        ints(arg0: number, arg1: number): Internal.IntStream;
        nextFloat(arg0: number): number;
        getDefault(): this;
        abstract nextLong(): number;
        nextDouble(): number;
        nextLong(arg0: number, arg1: number): number;
        nextGaussian(): number;
        doubles(arg0: number, arg1: number, arg2: number): Internal.DoubleStream;
        nextDouble(arg0: number): number;
        nextInt(arg0: number): number;
        nextFloat(): number;
        nextLong(arg0: number): number;
        ints(arg0: number, arg1: number, arg2: number): Internal.IntStream;
        nextFloat(arg0: number, arg1: number): number;
        of(arg0: string): this;
        doubles(): Internal.DoubleStream;
        nextInt(): number;
        nextBytes(arg0: number[]): void;
        longs(arg0: number): Internal.LongStream;
        longs(arg0: number, arg1: number, arg2: number): Internal.LongStream;
        nextBoolean(): boolean;
        nextDouble(arg0: number, arg1: number): number;
        nextExponential(): number;
        longs(arg0: number, arg1: number): Internal.LongStream;
        nextInt(arg0: number, arg1: number): number;
        longs(): Internal.LongStream;
        isDeprecated(): boolean;
        doubles(arg0: number): Internal.DoubleStream;
        nextGaussian(arg0: number, arg1: number): number;
        ints(): Internal.IntStream;
        ints(arg0: number): Internal.IntStream;
        doubles(arg0: number, arg1: number): Internal.DoubleStream;
        get "default"(): Internal.RandomGenerator
        get deprecated(): boolean
        (): number;
    }
    type RandomGenerator_ = (()=> number) | RandomGenerator;
    interface SleepingBlockEntity {
        startSleeping(): boolean;
        abstract getSleepingTicker(): Internal.TickingBlockEntity;
        wakeUpNow(): void;
        isSleeping(): boolean;
        abstract setTickWrapper(arg0: Internal.RebindableTickingBlockEntityWrapperAccessor_): void;
        setTicker(arg0: Internal.TickingBlockEntity_): void;
        abstract setSleepingTicker(arg0: Internal.TickingBlockEntity_): void;
        sleepOnlyCurrentTick(): void;
        abstract getTickWrapper(): Internal.RebindableTickingBlockEntityWrapperAccessor;
        get sleepingTicker(): Internal.TickingBlockEntity
        get sleeping(): boolean
        set tickWrapper(arg0: Internal.RebindableTickingBlockEntityWrapperAccessor_)
        set ticker(arg0: Internal.TickingBlockEntity_)
        set sleepingTicker(arg0: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.RebindableTickingBlockEntityWrapperAccessor
        readonly SLEEPING_BLOCK_ENTITY_TICKER: Internal.TickingBlockEntity;
    }
    type SleepingBlockEntity_ = SleepingBlockEntity;
    interface SignApplicator {
        abstract tryApplyToSign(arg0: Internal.Level_, arg1: Internal.SignBlockEntity_, arg2: boolean, arg3: Internal.Player_): boolean;
        canApplyToSign(arg0: Internal.SignText_, arg1: Internal.Player_): boolean;
        (arg0: Internal.Level, arg1: Internal.SignBlockEntity, arg2: boolean, arg3: Internal.Player): boolean;
    }
    type SignApplicator_ = ((arg0: Internal.Level, arg1: Internal.SignBlockEntity, arg2: boolean, arg3: Internal.Player)=> boolean) | SignApplicator;
    abstract class MethodHandle implements Internal.Constable {
        getClass(): typeof any;
        invokeExact(...arg0: any[]): any;
        invokeWithArguments(...arg0: any[]): any;
        type(): Internal.MethodType;
        isVarargsCollector(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        asCollector(arg0: typeof any, arg1: number): this;
        toString(): string;
        describeConstable(): Optional<Internal.MethodHandleDesc>;
        notifyAll(): void;
        withVarargs(arg0: boolean): this;
        asSpreader(arg0: typeof any, arg1: number): this;
        asFixedArity(): this;
        asVarargsCollector(arg0: typeof any): this;
        asCollector(arg0: number, arg1: typeof any, arg2: number): this;
        "invokeWithArguments(java.lang.Object[])"(...arg0: any[]): any;
        hashCode(): number;
        invokeWithArguments(arg0: Internal.List_<any>): any;
        wait(): void;
        invoke(...arg0: any[]): any;
        asType(arg0: Internal.MethodType_): this;
        wait(arg0: number): void;
        asSpreader(arg0: number, arg1: typeof any, arg2: number): this;
        "invokeWithArguments(java.util.List)"(arg0: Internal.List_<any>): any;
        equals(arg0: any): boolean;
        bindTo(arg0: any): this;
        get class(): typeof any
        get varargsCollector(): boolean
    }
    type MethodHandle_ = MethodHandle;
    class ScreenEventListener implements Internal.NarratableEntry, Internal.GuiEventListener {
        constructor(arg0: Internal.IGuiIntegratedParent_, arg1: Internal.Screen_)
        charTyped(arg0: string, arg1: number): boolean;
        getClass(): typeof any;
        isFocused(): boolean;
        setFocused(arg0: boolean): void;
        isActive(): boolean;
        getTabOrderGroup(): number;
        mouseClicked(arg0: number, arg1: number, arg2: number): boolean;
        keyReleased(arg0: number, arg1: number, arg2: number): boolean;
        mouseScrolled(arg0: number, arg1: number, arg2: number): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        mouseDragged(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        mouseMoved(arg0: number, arg1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        nextFocusPath(arg0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        toString(): string;
        narrationPriority(): Internal.NarratableEntry$NarrationPriority;
        notifyAll(): void;
        mouseReleased(arg0: number, arg1: number, arg2: number): boolean;
        getOffsetX(): number;
        getOffsetY(): number;
        tick(): void;
        keyPressed(arg0: number, arg1: number, arg2: number): boolean;
        hashCode(): number;
        getCurrentFocusPath(): Internal.ComponentPath;
        updateNarration(arg0: Internal.NarrationElementOutput_): void;
        wait(): void;
        getEventTime(): number;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isMouseOver(arg0: number, arg1: number): boolean;
        get class(): typeof any
        get focused(): boolean
        set focused(arg0: boolean)
        get active(): boolean
        get tabOrderGroup(): number
        get rectangle(): Internal.ScreenRectangle
        get offsetX(): number
        get offsetY(): number
        get currentFocusPath(): Internal.ComponentPath
        get eventTime(): number
        static readonly DOUBLE_CLICK_TIME: (0.2) & (number);
    }
    type ScreenEventListener_ = ScreenEventListener;
    class CriterionProgress {
        constructor()
        getClass(): typeof any;
        grant(): void;
        serializeToJson(): Internal.JsonElement;
        toString(): string;
        getObtained(): Internal.Date;
        notifyAll(): void;
        revoke(): void;
        isDone(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static fromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.CriterionProgress;
        hashCode(): number;
        wait(): void;
        static fromJson(arg0: string): Internal.CriterionProgress;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        serializeToNetwork(arg0: Internal.FriendlyByteBuf_): void;
        get class(): typeof any
        get obtained(): Internal.Date
        get done(): boolean
    }
    type CriterionProgress_ = CriterionProgress;
    interface LongSortedSet extends Internal.LongSet, Internal.SortedSet<number>, Internal.LongBidirectionalIterable {
        abstract firstLong(): number;
        abstract remove(arg0: number): boolean;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        last(): any;
        of(arg0: number, arg1: number, arg2: number): Internal.LongSet;
        /**
         * @deprecated
        */
        subSet(arg0: any, arg1: any): Internal.SortedSet<any>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        headSet(arg0: number): this;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        "headSet(java.lang.Object)"(arg0: any): Internal.SortedSet<any>;
        /**
         * @deprecated
        */
        "contains(java.lang.Object)"(arg0: any): boolean;
        abstract addAll(arg0: Internal.LongCollection_): boolean;
        abstract "remove(long)"(arg0: number): boolean;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        abstract "removeAll(java.util.Collection)"(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        "removeIf(java.util.function.Predicate)"(arg0: Internal.Predicate_<number>): boolean;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        "removeIf(it.unimi.dsi.fastutil.longs.LongPredicate)"(arg0: it.unimi.dsi.fastutil.longs.LongPredicate_): boolean;
        of(arg0: number, arg1: number): Internal.LongSet;
        /**
         * @deprecated
        */
        first(): number;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        longSpliterator(): Internal.LongSpliterator;
        "of(long)"(arg0: number): Internal.LongSet;
        /**
         * @deprecated
        */
        "headSet(java.lang.Long)"(arg0: number): this;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        "forEach(java.util.function.LongConsumer)"(arg0: Internal.LongConsumer_): void;
        abstract "headSet(long)"(arg0: number): this;
        iterator(): Internal.LongIterator;
        longIterator(): Internal.LongIterator;
        abstract subSet(arg0: number, arg1: number): this;
        abstract "contains(long)"(arg0: number): boolean;
        /**
         * @deprecated
        */
        toLongArray(arg0: number[]): number[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract toArray(arg0: number[]): number[];
        of(...arg0: number[]): Internal.LongSet;
        abstract lastLong(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        abstract "add(long)"(arg0: number): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        "tailSet(java.lang.Object)"(arg0: any): Internal.SortedSet<any>;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of(): Internal.LongSet;
        /**
         * @deprecated
        */
        rem(arg0: number): boolean;
        abstract "addAll(java.util.Collection)"(arg0: Internal.Collection_<number>): boolean;
        abstract toLongArray(): number[];
        abstract size(): number;
        longParallelStream(): Internal.LongStream;
        "of(long[])"(...arg0: number[]): Internal.LongSet;
        abstract clear(): void;
        /**
         * @deprecated
        */
        tailSet(arg0: number): this;
        abstract headSet(arg0: number): this;
        /**
         * @deprecated
        */
        "forEach(java.util.function.Consumer)"(arg0: Internal.Consumer_<number>): void;
        "removeIf(java.util.function.LongPredicate)"(arg0: Internal.LongPredicate_): boolean;
        removeIf(arg0: Internal.LongPredicate_): boolean;
        abstract "subSet(long,long)"(arg0: number, arg1: number): this;
        "of(long,long,long)"(arg0: number, arg1: number, arg2: number): Internal.LongSet;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        of(arg0: number): Internal.LongSet;
        abstract "containsAll(java.util.Collection)"(arg0: Internal.Collection_<any>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        abstract tailSet(arg0: number): this;
        abstract retainAll(arg0: Internal.LongCollection_): boolean;
        /**
         * @deprecated
        */
        "subSet(java.lang.Object,java.lang.Object)"(arg0: any, arg1: any): Internal.SortedSet<any>;
        abstract iterator(arg0: number): Internal.LongBidirectionalIterator;
        abstract "retainAll(java.util.Collection)"(arg0: Internal.Collection_<any>): boolean;
        forEach(arg0: Internal.LongConsumer_): void;
        comparator(): Comparator<any>;
        "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.Set<E>;
        /**
         * @deprecated
        */
        "remove(java.lang.Object)"(arg0: any): boolean;
        /**
         * @deprecated
        */
        subSet(arg0: number, arg1: number): this;
        abstract "tailSet(long)"(arg0: number): this;
        forEach(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        abstract removeAll(arg0: Internal.LongCollection_): boolean;
        abstract containsAll(arg0: Internal.LongCollection_): boolean;
        of<E>(arg0: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        "tailSet(java.lang.Long)"(arg0: number): this;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        "of(java.lang.Object,java.lang.Object)"<E>(arg0: E, arg1: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        "subSet(java.lang.Long,java.lang.Long)"(arg0: number, arg1: number): this;
        abstract "addAll(it.unimi.dsi.fastutil.longs.LongCollection)"(arg0: Internal.LongCollection_): boolean;
        abstract "toArray(long[])"(arg0: number[]): number[];
        abstract "removeAll(it.unimi.dsi.fastutil.longs.LongCollection)"(arg0: Internal.LongCollection_): boolean;
        /**
         * @deprecated
        */
        tailSet(arg0: any): Internal.SortedSet<any>;
        abstract add(arg0: number): boolean;
        abstract isEmpty(): boolean;
        /**
         * @deprecated
        */
        "add(java.lang.Object)"(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        abstract "retainAll(it.unimi.dsi.fastutil.longs.LongCollection)"(arg0: Internal.LongCollection_): boolean;
        "of(long,long)"(arg0: number, arg1: number): Internal.LongSet;
        /**
         * @deprecated
        */
        "add(java.lang.Long)"(arg0: number): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        headSet(arg0: any): Internal.SortedSet<any>;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract "containsAll(it.unimi.dsi.fastutil.longs.LongCollection)"(arg0: Internal.LongCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        abstract contains(arg0: number): boolean;
        "of(java.lang.Object,java.lang.Object,java.lang.Object)"<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        abstract "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        abstract toArray(): any[];
        "forEach(it.unimi.dsi.fastutil.longs.LongConsumer)"(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        abstract hashCode(): number;
        of<E>(...arg0: E[]): Internal.Set<E>;
        longStream(): Internal.LongStream;
        abstract equals(arg0: any): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.longs.LongPredicate_): boolean;
        "of(java.lang.Object)"<E>(arg0: E): Internal.Set<E>;
        get empty(): boolean
    }
    type LongSortedSet_ = LongSortedSet;
    class FlaxBlock extends Internal.CropBlock implements Internal.IBeeGrowable {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(worldIn: Internal.Level_, player: Internal.Player_, pos: BlockPos_, state: Internal.BlockState_, te: Internal.BlockEntity_, stack: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerWillDestroy(worldIn: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, player: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        isMaxAge(arg0: Internal.BlockState_): boolean;
        getPlant(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        use(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, rayTraceResult: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        isSingle(state: Internal.BlockState_): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        handler$zkl000$mayPlaceOn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CallbackInfoReturnable_<any>): void;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        getMaxAge(): number;
        updateShape(stateIn: Internal.BlockState_, facing: Internal.Direction_, facingState: Internal.BlockState_, worldIn: Internal.LevelAccessor_, currentPos: BlockPos_, facingPos: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        canGrowUp(worldIn: Internal.BlockGetter_, downPos: BlockPos_): boolean;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        placeAt(worldIn: Internal.LevelAccessor_, pos: BlockPos_, flags: number): void;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(pState: Internal.BlockState_, pUseContext: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        getPollinated(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        isValidBonemealTarget(worldIn: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(state: Internal.BlockState_, worldIn: Internal.LevelReader_, pos: BlockPos_): boolean;
        growCrops(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getAge(arg0: Internal.BlockState_): number;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getStateForAge(arg0: number): Internal.BlockState;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        canBeReplaced(pState: Internal.BlockState_, pUseContext: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(state: Internal.BlockState_, worldIn: Internal.BlockGetter_, pos: BlockPos_, context: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        growCropBy(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, increment: number): void;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        get maxAge(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly DOUBLE_AGE: (4) & (number);
        static readonly HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    }
    type FlaxBlock_ = FlaxBlock;
    interface ImageConsumer {
        abstract setPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setHints(arg0: number): void;
        abstract setDimensions(arg0: number, arg1: number): void;
        abstract setProperties(arg0: Internal.Hashtable_<any, any>): void;
        abstract "setPixels(int,int,int,int,java.awt.image.ColorModel,byte[],int,int)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract imageComplete(arg0: number): void;
        abstract "setPixels(int,int,int,int,java.awt.image.ColorModel,int[],int,int)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.ColorModel_, arg5: number[], arg6: number, arg7: number): void;
        abstract setColorModel(arg0: Internal.ColorModel_): void;
        set hints(arg0: number)
        set properties(arg0: Internal.Hashtable_<any, any>)
        set colorModel(arg0: Internal.ColorModel_)
        readonly COMPLETESCANLINES: (4) & (number);
        readonly SINGLEPASS: (8) & (number);
        readonly SINGLEFRAME: (16) & (number);
        readonly RANDOMPIXELORDER: (1) & (number);
        readonly TOPDOWNLEFTRIGHT: (2) & (number);
        readonly IMAGEERROR: (1) & (number);
        readonly STATICIMAGEDONE: (3) & (number);
        readonly IMAGEABORTED: (4) & (number);
        readonly SINGLEFRAMEDONE: (2) & (number);
    }
    type ImageConsumer_ = ImageConsumer;
    interface DoubleIterator extends Internal.PrimitiveIterator$OfDouble {
        forEachRemaining(arg0: any): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        "forEachRemaining(java.util.function.DoubleConsumer)"(arg0: Internal.DoubleConsumer_): void;
        /**
         * @deprecated
        */
        next(): any;
        skip(arg0: number): number;
        abstract nextDouble(): number;
        "forEachRemaining(it.unimi.dsi.fastutil.doubles.DoubleConsumer)"(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        remove(): void;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        "forEachRemaining(java.lang.Object)"(arg0: any): void;
        /**
         * @deprecated
        */
        "forEachRemaining(java.util.function.Consumer)"(arg0: Internal.Consumer_<number>): void;
        abstract hasNext(): boolean;
    }
    type DoubleIterator_ = DoubleIterator;
    interface ClientPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        setSelectedSlot(index: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isLiving(): boolean;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(tag: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getCraftingGrid(): Internal.InventoryKJS;
        setXpLevel(l: number): void;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setXp(xp: number): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(notification: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        self(): Internal.Player;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        isSelf(): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        abstract getData(): Internal.AttachedData<Internal.Player>;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get craftingGrid(): Internal.InventoryKJS
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get self(): boolean
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        (): Internal.AttachedData_<Internal.Player>;
    }
    type ClientPlayerKJS_ = ClientPlayerKJS | (()=> Internal.AttachedData_<Internal.Player>);
    interface ProgressListener {
        abstract progressStart(arg0: net.minecraft.network.chat.Component_): void;
        abstract stop(): void;
        abstract progressStartNoAbort(arg0: net.minecraft.network.chat.Component_): void;
        abstract progressStagePercentage(arg0: number): void;
        abstract progressStage(arg0: net.minecraft.network.chat.Component_): void;
    }
    type ProgressListener_ = ProgressListener;
    class PaletteItem$PaletteMode extends Internal.Enum<Internal.PaletteItem$PaletteMode> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.PaletteItem$PaletteMode>>;
        toString(): string;
        getDeclaringClass(): typeof Internal.PaletteItem$PaletteMode;
        compareTo(arg0: Internal.PaletteItem$PaletteMode_): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static values(): Internal.PaletteItem$PaletteMode[];
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        static valueOf(name: string): Internal.PaletteItem$PaletteMode;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        "compareTo(net.nicguzzo.wands.items.PaletteItem$PaletteMode)"(arg0: Internal.PaletteItem$PaletteMode_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.PaletteItem$PaletteMode
        static readonly RANDOM: (Internal.PaletteItem$PaletteMode) & (Internal.PaletteItem$PaletteMode);
        static readonly ROUND_ROBIN: (Internal.PaletteItem$PaletteMode) & (Internal.PaletteItem$PaletteMode);
    }
    type PaletteItem$PaletteMode_ = "round_robin" | PaletteItem$PaletteMode | "random";
    class RegExFilterItem extends Internal.StringValueFilterItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(stack: Internal.ItemStack_, world: Internal.Level_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, flag: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        getDisplayItemStacks(filter: Internal.ItemStack_, list: Internal.List_<Internal.ItemStack>): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getValue(filter: Internal.ItemStack_): string;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(world: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        filter(filter: Internal.ItemStack_, stack: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        createData(stack: Internal.ItemStack_): Internal.StringValueData<any>;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getHelpKey(): string;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getStringValueData<T extends Internal.StringValueData<any>>(filter: Internal.ItemStack_): T;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(stack: Internal.ItemStack_, level: Internal.Level_, entity: Internal.Entity_, i: number, bl: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        clearFilterCache(filter: Internal.ItemStack_): void;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        setValue(filter: Internal.ItemStack_, v: string): void;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        filterItem(filter: Internal.ItemStack_, item: Internal.Item_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        getValueVariants(stack: Internal.ItemStack_): Internal.Collection<Internal.StringValueFilterVariant>;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        addInfo(filter: Internal.ItemStack_, info: Internal.FilterInfo_, expanded: boolean): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        resetFilterData(filter: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get helpKey(): string
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type RegExFilterItem_ = RegExFilterItem;
    class BeehiveBlockEntity$BeeReleaseStatus extends Internal.Enum<Internal.BeehiveBlockEntity$BeeReleaseStatus> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        "compareTo(net.minecraft.world.level.block.entity.BeehiveBlockEntity$BeeReleaseStatus)"(arg0: Internal.BeehiveBlockEntity$BeeReleaseStatus_): number;
        toString(): string;
        notifyAll(): void;
        static values(): Internal.BeehiveBlockEntity$BeeReleaseStatus[];
        compareTo(arg0: Internal.BeehiveBlockEntity$BeeReleaseStatus_): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        getDeclaringClass(): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        static valueOf(arg0: string): Internal.BeehiveBlockEntity$BeeReleaseStatus;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.BeehiveBlockEntity$BeeReleaseStatus>>;
        get class(): typeof any
        get declaringClass(): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus
        static readonly EMERGENCY: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
        static readonly HONEY_DELIVERED: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
        static readonly BEE_RELEASED: (Internal.BeehiveBlockEntity$BeeReleaseStatus) & (Internal.BeehiveBlockEntity$BeeReleaseStatus);
    }
    type BeehiveBlockEntity$BeeReleaseStatus_ = "bee_released" | "honey_delivered" | BeehiveBlockEntity$BeeReleaseStatus | "emergency";
    interface IClientConfiguration {
        abstract getInvertBitBagFullness(): Internal.Supplier<boolean>;
        abstract getEnableMouseIndicatorInRadialMenu(): Internal.Supplier<boolean>;
        abstract getPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>;
        abstract getPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>;
        abstract getShouldBrokenBlocksBeAddedToClipboard(): Internal.Supplier<boolean>;
        getInstance(): this;
        abstract getFaceLayerCacheSize(): Internal.Supplier<number>;
        abstract getPatternExportPath(): Internal.Supplier<string>;
        abstract getUseGetLightValue(): Internal.Supplier<boolean>;
        abstract getFailedPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>;
        abstract getBitStorageContentCacheSize(): Internal.Supplier<number>;
        abstract getMutatorPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>;
        abstract getPreviewRenderer(): Internal.Supplier<string>;
        abstract getShouldScrollInteractionsChangeMode(): Internal.Supplier<boolean>;
        abstract getInvertPickBlockBehaviour(): Internal.Supplier<boolean>;
        abstract getModelBuildingThreadCount(): Internal.Supplier<number>;
        abstract getSuccessfulPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getToolModeRenderer(): Internal.Supplier<string>;
        abstract getMissingBitsOrSpacePatternPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getModelCacheSize(): Internal.Supplier<number>;
        abstract getShowCoolDownError(): Internal.Supplier<boolean>;
        abstract getMutatorPreviewDebug(): Internal.Supplier<boolean>;
        abstract getEnableFaceLightmapExtraction(): Internal.Supplier<boolean>;
        abstract getSuccessfulPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>;
        abstract getMutatorPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>;
        abstract getNotFittingPatternPlacementColor(): Internal.Supplier<Vec4f>;
        abstract getCullTestingCacheSize(): Internal.Supplier<number>;
        abstract getClipboardSize(): Internal.Supplier<number>;
        abstract getStackModelCacheSize(): Internal.Supplier<number>;
        abstract getShouldPickedBlocksBeAddedToClipboard(): Internal.Supplier<boolean>;
        get invertBitBagFullness(): Internal.Supplier<boolean>
        get enableMouseIndicatorInRadialMenu(): Internal.Supplier<boolean>
        get previewPlacementColor(): Internal.Supplier<Internal.List<number>>
        get previewChiselingColor(): Internal.Supplier<Internal.List<number>>
        get shouldBrokenBlocksBeAddedToClipboard(): Internal.Supplier<boolean>
        get instance(): Internal.IClientConfiguration
        get faceLayerCacheSize(): Internal.Supplier<number>
        get patternExportPath(): Internal.Supplier<string>
        get useGetLightValue(): Internal.Supplier<boolean>
        get failedPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>
        get bitStorageContentCacheSize(): Internal.Supplier<number>
        get mutatorPreviewChiselingColor(): Internal.Supplier<Internal.List<number>>
        get previewRenderer(): Internal.Supplier<string>
        get shouldScrollInteractionsChangeMode(): Internal.Supplier<boolean>
        get invertPickBlockBehaviour(): Internal.Supplier<boolean>
        get modelBuildingThreadCount(): Internal.Supplier<number>
        get successfulPlacementColor(): Internal.Supplier<Vec4f>
        get toolModeRenderer(): Internal.Supplier<string>
        get missingBitsOrSpacePatternPlacementColor(): Internal.Supplier<Vec4f>
        get modelCacheSize(): Internal.Supplier<number>
        get showCoolDownError(): Internal.Supplier<boolean>
        get mutatorPreviewDebug(): Internal.Supplier<boolean>
        get enableFaceLightmapExtraction(): Internal.Supplier<boolean>
        get successfulPlacementRenderMode(): Internal.Supplier<Internal.PlacementPreviewRenderMode>
        get mutatorPreviewPlacementColor(): Internal.Supplier<Internal.List<number>>
        get notFittingPatternPlacementColor(): Internal.Supplier<Vec4f>
        get cullTestingCacheSize(): Internal.Supplier<number>
        get clipboardSize(): Internal.Supplier<number>
        get stackModelCacheSize(): Internal.Supplier<number>
        get shouldPickedBlocksBeAddedToClipboard(): Internal.Supplier<boolean>
    }
    type IClientConfiguration_ = IClientConfiguration;
    class SignableCommand <S> extends Internal.Record {
        constructor(arg0: Internal.List_<Internal.SignableCommand$Argument<S>>)
        static of<S>(arg0: Internal.ParseResults_<S>): Internal.SignableCommand<S>;
        getClass(): typeof any;
        hashCode(): number;
        "arguments"(): Internal.List<Internal.SignableCommand$Argument<S>>;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type SignableCommand_<S> = SignableCommand<S>;
    class CustomizeGuiOverlayEvent$Chat extends Internal.CustomizeGuiOverlayEvent {
        constructor(arg0: com.mojang.blaze3d.platform.Window_, arg1: Internal.GuiGraphics_, arg2: number, arg3: number, arg4: number)
        constructor()
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        getGuiGraphics(): Internal.GuiGraphics;
        getPartialTick(): number;
        getWindow(): com.mojang.blaze3d.platform.Window;
        setPhase(arg0: Internal.EventPriority_): void;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getPosY(): number;
        getPosX(): number;
        isCancelable(): boolean;
        getListenerList(): Internal.ListenerList;
        getResult(): Internal.Event$Result;
        toString(): string;
        notifyAll(): void;
        setPosX(arg0: number): void;
        setPosY(arg0: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        set canceled(arg0: boolean)
        get class(): typeof any
        get guiGraphics(): Internal.GuiGraphics
        get partialTick(): number
        get window(): com.mojang.blaze3d.platform.Window
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        get posY(): number
        get posX(): number
        get cancelable(): boolean
        get listenerList(): Internal.ListenerList
        get result(): Internal.Event$Result
        set posX(arg0: number)
        set posY(arg0: number)
        set result(arg0: Internal.Event$Result_)
        get phase(): Internal.EventPriority
    }
    type CustomizeGuiOverlayEvent$Chat_ = CustomizeGuiOverlayEvent$Chat;
    class BiomeSpecialEffectsBuilder extends Internal.BiomeSpecialEffects$Builder {
        getClass(): typeof any;
        getAmbientAdditionsSound(): Optional<Internal.AmbientAdditionsSettings>;
        ambientAdditionsSound(arg0: Internal.AmbientAdditionsSettings_): Internal.BiomeSpecialEffects$Builder;
        waterColor(): number;
        grassColorOverride(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getAmbientMoodSound(): Optional<Internal.AmbientMoodSettings>;
        getFoliageColorOverride(): Optional<number>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        ambientParticle(arg0: Internal.AmbientParticleSettings_): Internal.BiomeSpecialEffects$Builder;
        getAmbientLoopSound(): Optional<Internal.Holder<Internal.SoundEvent>>;
        build(): Internal.BiomeSpecialEffects;
        waterFogColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getGrassColorOverride(): Optional<number>;
        puzzleslib$setBackgroundMusic(arg0: Optional_<any>): void;
        puzzleslib$setGrassColorOverride(arg0: Optional_<any>): void;
        getFogColor(): number;
        getSkyColor(): number;
        grassColorModifier(arg0: Internal.BiomeSpecialEffects$GrassColorModifier_): Internal.BiomeSpecialEffects$Builder;
        static create(arg0: number, arg1: number, arg2: number, arg3: number): Internal.BiomeSpecialEffectsBuilder;
        getGrassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier;
        static copyOf(arg0: Internal.BiomeSpecialEffects_): Internal.BiomeSpecialEffectsBuilder;
        toString(): string;
        fogColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        ambientLoopSound(arg0: Internal.Holder_<Internal.SoundEvent>): Internal.BiomeSpecialEffects$Builder;
        backgroundMusic(arg0: Internal.Music_): Internal.BiomeSpecialEffects$Builder;
        notifyAll(): void;
        puzzleslib$setAmbientAdditionsSettings(arg0: Optional_<any>): void;
        waterColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        ambientMoodSound(arg0: Internal.AmbientMoodSettings_): Internal.BiomeSpecialEffects$Builder;
        puzzleslib$setFoliageColorOverride(arg0: Optional_<any>): void;
        hashCode(): number;
        getBackgroundMusic(): Optional<Internal.Music>;
        foliageColorOverride(arg0: number): Internal.BiomeSpecialEffects$Builder;
        getWaterFogColor(): number;
        puzzleslib$setAmbientMoodSettings(arg0: Optional_<any>): void;
        wait(): void;
        wait(arg0: number): void;
        puzzleslib$setAmbientParticle(arg0: Optional_<any>): void;
        getAmbientParticle(): Optional<Internal.AmbientParticleSettings>;
        skyColor(arg0: number): Internal.BiomeSpecialEffects$Builder;
        equals(arg0: any): boolean;
        puzzleslib$setAmbientLoopSoundEvent(arg0: Optional_<any>): void;
        get class(): typeof any
        get ambientAdditionsSound(): Optional<Internal.AmbientAdditionsSettings>
        get ambientMoodSound(): Optional<Internal.AmbientMoodSettings>
        get foliageColorOverride(): Optional<number>
        get ambientLoopSound(): Optional<Internal.Holder<Internal.SoundEvent>>
        get grassColorOverride(): Optional<number>
        get fogColor(): number
        get skyColor(): number
        get grassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier
        get backgroundMusic(): Optional<Internal.Music>
        get waterFogColor(): number
        get ambientParticle(): Optional<Internal.AmbientParticleSettings>
    }
    type BiomeSpecialEffectsBuilder_ = BiomeSpecialEffectsBuilder;
    abstract class MapWriter {
        constructor(arg0: Internal.OverlayManager_, arg1: Internal.BlockStateShortShapeCache_, arg2: Internal.BiomeGetter_)
        getClass(): typeof any;
        modifyExpressionValue$coj000$obsidianRoofOverlayMod(original: boolean, bChunk: Internal.LevelChunk_, b: Internal.Block_, h: number): boolean;
        writeMap(arg0: Internal.Level_, arg1: Internal.Registry_<Internal.Block>, arg2: number, arg3: number, arg4: number, arg5: Internal.Registry_<Internal.Biome>, arg6: Internal.BiomeColorCalculator_, arg7: Internal.OverlayManager_, arg8: boolean, arg9: boolean, arg10: boolean, arg11: boolean, arg12: boolean, arg13: Internal.BlockPos$MutableBlockPos_, arg14: Internal.BlockTintProvider_, arg15: number): boolean;
        writeChunk(arg0: Internal.Level_, arg1: Internal.Registry_<Internal.Block>, arg2: number, arg3: boolean, arg4: Internal.Registry_<Internal.Biome>, arg5: Internal.OverlayManager_, arg6: boolean, arg7: boolean, arg8: boolean, arg9: boolean, arg10: boolean, arg11: Internal.BlockPos$MutableBlockPos_, arg12: Internal.BlockTintProvider_, arg13: number, arg14: number, arg15: number, arg16: number, arg17: number, arg18: number, arg19: number, arg20: number, arg21: number): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        isInvisible(arg0: Internal.BlockState_, arg1: Internal.Block_, arg2: boolean): boolean;
        setDirtyInWriteDistance(arg0: Internal.Player_, arg1: Internal.Level_): void;
        handler$coj000$writeChunk(world: Internal.Level_, blockRegistry: Internal.Registry_<any>, distance: number, onlyLoad: boolean, biomeRegistry: Internal.Registry_<any>, overlayManager: Internal.OverlayManager_, loadChunks: boolean, updateChunks: boolean, ignoreHeightmaps: boolean, flowers: boolean, detailedDebug: boolean, mutableBlockPos3: Internal.BlockPos$MutableBlockPos_, blockTintProvider: Internal.BlockTintProvider_, caveDepth: number, caveStart: number, layerToWrite: number, tileChunkX: number, tileChunkZ: number, tileChunkLocalX: number, tileChunkLocalZ: number, chunkX: number, chunkZ: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$coj000$setObsidianColumnLocalVar(world: Internal.Level_, blockRegistry: Internal.Registry_<any>, pixel: Internal.MapBlock_, currentPixel: Internal.MapBlock_, bchunk: Internal.LevelChunk_, insideX: number, insideZ: number, highY: number, lowY: number, cave: boolean, fullCave: boolean, mappedHeight: number, canReuseBiomeColours: boolean, ignoreHeightmaps: boolean, biomeRegistry: Internal.Registry_<any>, flowers: boolean, worldBottomY: number, mutableBlockPos3: Internal.BlockPos$MutableBlockPos_, ci: Internal.CallbackInfo_, columnRoofObsidianRef: Internal.LocalBooleanRef_): void;
        getBlockTintIndex(arg0: Internal.BlockState_): number;
        updateBottomRightTile(arg0: Internal.MapRegion_, arg1: Internal.MapTileChunk_, arg2: Internal.MapTileChunk_, arg3: number, arg4: number): void;
        wrapOperation$coj000$getOpacityForObsidianRoof(instance: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, original: Internal.Operation_<any>, h: number): number;
        requestCachedColoursClear(): void;
        hasVanillaColor(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.Registry_<Internal.Block>, arg3: BlockPos_): boolean;
        getUpdateCounter(): number;
        toString(): string;
        shouldOverlay(arg0: Internal.StateHolder_<any, any>): boolean;
        notifyAll(): void;
        wrapOperation$coj000$checkObsidianRoofColumn(instance: Internal.OverlayBuilder_, original: Internal.Operation_<any>, columnRoofObsidianRef: Internal.LocalBooleanRef_): boolean;
        getSectionBasedHeight(arg0: Internal.LevelChunk_, arg1: number): number;
        modifyExpressionValue$coj000$removeWriteTimeLimiterPerFrame(original: number): number;
        resetPosition(): void;
        setMapProcessor(arg0: Internal.MapProcessor_): void;
        onRender(arg0: Internal.BiomeColorCalculator_, arg1: Internal.OverlayManager_): void;
        hashCode(): number;
        isGlowing(arg0: Internal.BlockState_): boolean;
        wait(): void;
        handler$coj000$obsidianRoofHeadInject(world: Internal.Level_, blockRegistry: Internal.Registry_<any>, pixel: Internal.MapBlock_, currentPixel: Internal.MapBlock_, bchunk: Internal.LevelChunk_, insideX: number, insideZ: number, highY: number, lowY: number, cave: boolean, fullCave: boolean, mappedHeight: number, canReuseBiomeColours: boolean, ignoreHeightmaps: boolean, biomeRegistry: Internal.Registry_<any>, flowers: boolean, worldBottomY: number, mutableBlockPos3: Internal.BlockPos$MutableBlockPos_, ci: Internal.CallbackInfo_, stateRef: Internal.LocalRef_<any>, hRef: Internal.LocalIntRef_, transparentSkipYRef: Internal.LocalIntRef_, columnRoofObsidianRef: Internal.LocalBooleanRef_): void;
        wait(arg0: number): void;
        wrapOperation$coj000$getOpacityForObsidianRoof$mixinextras$bridge$37(instance: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, original: Internal.Operation_<any>, h: Internal.LocalIntRef_): number;
        equals(arg0: any): boolean;
        handler$coj000$fastMapMaxTilesPerCycleSetting(biomeColorCalculator: Internal.BiomeColorCalculator_, overlayManager: Internal.OverlayManager_, ci: Internal.CallbackInfo_, tilesToUpdateRef: Internal.LocalLongRef_, sizeTiles: number): void;
        loadPixel(arg0: Internal.Level_, arg1: Internal.Registry_<Internal.Block>, arg2: Internal.MapBlock_, arg3: Internal.MapBlock_, arg4: Internal.LevelChunk_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: boolean, arg10: boolean, arg11: number, arg12: boolean, arg13: boolean, arg14: Internal.Registry_<Internal.Biome>, arg15: boolean, arg16: number, arg17: Internal.BlockPos$MutableBlockPos_): void;
        loadBlockColourFromTexture(arg0: Internal.BlockState_, arg1: boolean, arg2: Internal.Level_, arg3: Internal.Registry_<Internal.Block>, arg4: BlockPos_): number;
        handler$coj000$netherCaveFixInject(world: Internal.Level_, blockRegistry: Internal.Registry_<any>, pixel: Internal.MapBlock_, currentPixel: Internal.MapBlock_, bchunk: Internal.LevelChunk_, insideX: number, insideZ: number, highY: number, lowY: number, cave: boolean, fullCave: boolean, mappedHeight: number, canReuseBiomeColours: boolean, ignoreHeightmaps: boolean, biomeRegistry: Internal.Registry_<any>, flowers: boolean, worldBottomY: number, mutableBlockPos3: Internal.BlockPos$MutableBlockPos_, ci: Internal.CallbackInfo_, caveRef: Internal.LocalBooleanRef_, fullCaveRef: Internal.LocalBooleanRef_): void;
        get class(): typeof any
        get updateCounter(): number
        set mapProcessor(arg0: Internal.MapProcessor_)
        static readonly NO_Y_VALUE: (32767) & (number);
        static readonly DEFAULT_RESOURCE: string[];
        writeFreeSinceLastWrite: number;
        static readonly MAX_TRANSPARENCY_BLEND_DEPTH: (5) & (number);
    }
    type MapWriter_ = MapWriter;
    class SemaphoreItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        abstract moonlight$addAdditionalBehavior(arg0: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        abstract moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        abstract moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        abstract moonlight$setClientAnimationExtension(arg0: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(pContext: Internal.BlockPlaceContext_): Internal.InteractionResult;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type SemaphoreItem_ = SemaphoreItem;
    interface WirelessTerminal {
        abstract open(arg0: Internal.Player_, arg1: Internal.ItemStack_): void;
        abstract canOpen(arg0: Internal.ItemStack_): boolean;
        abstract getRange(arg0: Internal.Player_, arg1: Internal.ItemStack_): number;
    }
    type WirelessTerminal_ = WirelessTerminal;
    class ImmutableCollections$List12 <E> extends Internal.ImmutableCollections$AbstractImmutableList<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        sort(arg0: Comparator_<E>): void;
        notify(): void;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        "remove(int)"(arg0: number): E;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<E>;
        indexOf(arg0: any): number;
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract "remove(java.lang.Object)"(arg0: any): boolean;
        listIterator(arg0: number): Internal.ListIterator<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.List<E>;
        lastIndexOf(arg0: any): number;
        getClass(): typeof any;
        get(arg0: number): E;
        abstract add(arg0: E): boolean;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        wait(arg0: number, arg1: number): void;
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        remove(arg0: number): E;
        contains(arg0: any): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static "of(java.lang.Object)"<E>(arg0: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        toString(): string;
        notifyAll(): void;
        "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        size(): number;
        hashCode(): number;
        abstract clear(): void;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableCollections$List12_<E> = ImmutableCollections$List12<E>;
    interface LocationAware {
        abstract requiresLocation(): boolean;
        (): boolean;
    }
    type LocationAware_ = LocationAware | (()=> boolean);
    class NarratedElementType extends Internal.Enum<Internal.NarratedElementType> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static valueOf(arg0: string): Internal.NarratedElementType;
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.NarratedElementType[];
        compareTo(arg0: Internal.NarratedElementType_): number;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.NarratedElementType>>;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        getDeclaringClass(): typeof Internal.NarratedElementType;
        "compareTo(net.minecraft.client.gui.narration.NarratedElementType)"(arg0: Internal.NarratedElementType_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.NarratedElementType
        static readonly HINT: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly POSITION: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly TITLE: (Internal.NarratedElementType) & (Internal.NarratedElementType);
        static readonly USAGE: (Internal.NarratedElementType) & (Internal.NarratedElementType);
    }
    type NarratedElementType_ = NarratedElementType | "hint" | "position" | "title" | "usage";
    class TrackGraphLocation {
        constructor()
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        edge: Internal.Couple<Internal.TrackNodeLocation>;
        position: number;
        graph: Internal.TrackGraph;
    }
    type TrackGraphLocation_ = TrackGraphLocation;
    abstract class SimpleChannelInboundHandler <I> extends Internal.ChannelInboundHandlerAdapter {
        getClass(): typeof any;
        channelActive(arg0: Internal.ChannelHandlerContext_): void;
        acceptInboundMessage(arg0: any): boolean;
        toString(): string;
        notifyAll(): void;
        isSharable(): boolean;
        handlerRemoved(arg0: Internal.ChannelHandlerContext_): void;
        channelReadComplete(arg0: Internal.ChannelHandlerContext_): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        channelWritabilityChanged(arg0: Internal.ChannelHandlerContext_): void;
        channelInactive(arg0: Internal.ChannelHandlerContext_): void;
        hashCode(): number;
        wait(): void;
        channelUnregistered(arg0: Internal.ChannelHandlerContext_): void;
        userEventTriggered(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        wait(arg0: number): void;
        exceptionCaught(arg0: Internal.ChannelHandlerContext_, arg1: Internal.Throwable_): void;
        handlerAdded(arg0: Internal.ChannelHandlerContext_): void;
        equals(arg0: any): boolean;
        channelRegistered(arg0: Internal.ChannelHandlerContext_): void;
        channelRead(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        get class(): typeof any
        get sharable(): boolean
    }
    type SimpleChannelInboundHandler_<I> = SimpleChannelInboundHandler<I>;
    class AMBlockItem extends Internal.BlockItem implements com.github.alexthe666.alexsmobs.item.CustomTabBehavior {
        constructor(arg0: Internal.RegistryObject_<Internal.Block>, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        abstract moonlight$addAdditionalBehavior(arg0: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        abstract moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        abstract moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        abstract moonlight$setClientAnimationExtension(arg0: any): void;
        fillItemCategory(arg0: Internal.CreativeModeTab$Output_): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        canFitInsideCraftingRemainingItems(): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(arg0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type AMBlockItem_ = AMBlockItem;
    class DoorControlBehaviour extends Internal.BlockEntityBehaviour {
        constructor(arg0: Internal.SmartBlockEntity_)
        getClass(): typeof any;
        isSafeNBT(): boolean;
        destroy(): void;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        onNeighborChanged(arg0: BlockPos_): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BehaviourType_<T>): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getPos(): BlockPos;
        unload(): void;
        read(arg0: Internal.CompoundTag_, arg1: boolean): void;
        setLazyTickRate(arg0: number): void;
        static get<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BlockEntity_, arg1: Internal.BehaviourType_<T>): T;
        initialize(): void;
        getWorld(): Internal.Level;
        toString(): string;
        notifyAll(): void;
        tick(): void;
        lazyTick(): void;
        hashCode(): number;
        set(arg0: Internal.DoorControl_): void;
        getRequiredItems(): Internal.ItemRequirement;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        onBlockChanged(arg0: Internal.BlockState_): void;
        getType(): Internal.BehaviourType<any>;
        get class(): typeof any
        get safeNBT(): boolean
        get pos(): BlockPos
        set lazyTickRate(arg0: number)
        get world(): Internal.Level
        get requiredItems(): Internal.ItemRequirement
        get type(): Internal.BehaviourType<any>
        static readonly TYPE: Internal.BehaviourType<Internal.DoorControlBehaviour>;
        mode: Internal.DoorControl;
    }
    type DoorControlBehaviour_ = DoorControlBehaviour;
    abstract class Axis extends Internal.Enum<Internal.Axis> {
        abstract "get(org.joml.Vector3f)"(arg0: Vec3f_): number;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.Axis>>;
        notify(): void;
        compareTo(arg0: any): number;
        abstract set(arg0: Internal.SectionPos_, arg1: number): Internal.SectionPos;
        abstract get(arg0: Internal.ChunkPos_): number;
        abstract set(arg0: Vec3d_, arg1: number): Vec3d;
        abstract "get(net.minecraft.world.level.ChunkPos)"(arg0: Internal.ChunkPos_): number;
        static get(arg0: Internal.Direction$Axis_): Internal.Axis;
        abstract get(arg0: Vec3d_): number;
        static third(arg0: Internal.Axis_, arg1: Internal.Axis_): Internal.Axis;
        abstract set(arg0: BlockPos_, arg1: number): BlockPos;
        compareTo(arg0: Internal.Axis_): number;
        "mirror(net.minecraft.core.Direction)"(arg0: Internal.Direction_): Internal.Direction;
        name(): string;
        mirror(arg0: team.creative.creativecore.common.util.math.vec.Vec3f_): void;
        wait(): void;
        abstract get(arg0: Vec3f_): number;
        abstract get(arg0: number, arg1: number, arg2: number): number;
        abstract get<T>(arg0: T, arg1: T, arg2: T): T;
        "compareTo(java.lang.Object)"(arg0: any): number;
        abstract get(arg0: number, arg1: number, arg2: number): number;
        abstract facing(arg0: boolean): Internal.Facing;
        abstract set(arg0: Internal.ChunkPos_, arg1: number): Internal.ChunkPos;
        getClass(): typeof any;
        abstract mirror(arg0: BlockPos_): BlockPos;
        abstract "set(net.minecraft.core.BlockPos,int)"(arg0: BlockPos_, arg1: number): BlockPos;
        getDeclaringClass(): typeof Internal.Axis;
        "mirror(team.creative.creativecore.common.util.math.base.Facing)"(arg0: Internal.Facing_): Internal.Facing;
        abstract "get(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
        abstract two(): this;
        wait(arg0: number, arg1: number): void;
        abstract "get(net.minecraft.world.phys.Vec3)"(arg0: Vec3d_): number;
        static valueOf(arg0: string): Internal.Axis;
        abstract set(arg0: Internal.BlockPos$MutableBlockPos_, arg1: number): void;
        abstract set(arg0: Vec3i_, arg1: number): Vec3i;
        abstract get(arg0: Internal.Vector3d_): number;
        abstract set(arg0: Internal.Vector3d_, arg1: number): void;
        abstract "set(net.minecraft.core.SectionPos,int)"(arg0: Internal.SectionPos_, arg1: number): Internal.SectionPos;
        abstract mirror(arg0: Vec3i_): Vec3i;
        abstract "set(net.minecraft.core.BlockPos$MutableBlockPos,int)"(arg0: Internal.BlockPos$MutableBlockPos_, arg1: number): void;
        static getMirrorAxis(arg0: Internal.Mirror_): Internal.Axis;
        abstract "set(org.joml.Vector3d,double)"(arg0: Internal.Vector3d_, arg1: number): void;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        abstract "get(int,int,int)"(arg0: number, arg1: number, arg2: number): number;
        toString(): string;
        mirror(arg0: Internal.Direction_): Internal.Direction;
        abstract set(arg0: Vec3f_, arg1: number): void;
        notifyAll(): void;
        static "get(net.minecraft.core.Direction$Axis)"(arg0: Internal.Direction$Axis_): Internal.Axis;
        mirror(arg0: Internal.Facing_): Internal.Facing;
        abstract "set(net.minecraft.core.Vec3i,int)"(arg0: Vec3i_, arg1: number): Vec3i;
        "mirror(team.creative.creativecore.common.util.math.vec.Vec3f)"(arg0: team.creative.creativecore.common.util.math.vec.Vec3f_): void;
        abstract "set(org.joml.Vector3f,float)"(arg0: Vec3f_, arg1: number): void;
        abstract "get(java.lang.Object,java.lang.Object,java.lang.Object)"<T>(arg0: T, arg1: T, arg2: T): T;
        "mirror(team.creative.creativecore.common.util.math.vec.Vec3d)"(arg0: team.creative.creativecore.common.util.math.vec.Vec3d_): void;
        abstract get(arg0: Vec3i_): number;
        mirror(arg0: team.creative.creativecore.common.util.math.vec.Vec3d_): void;
        abstract "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): number;
        hashCode(): number;
        abstract get(arg0: number, arg1: number, arg2: number): number;
        abstract one(): this;
        ordinal(): number;
        abstract "get(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
        abstract toVanilla(): Internal.Direction$Axis;
        static values(): Internal.Axis[];
        wait(arg0: number): void;
        abstract "set(net.minecraft.world.level.ChunkPos,int)"(arg0: Internal.ChunkPos_, arg1: number): Internal.ChunkPos;
        abstract "mirror(net.minecraft.core.BlockPos)"(arg0: BlockPos_): BlockPos;
        abstract "set(net.minecraft.world.phys.Vec3,double)"(arg0: Vec3d_, arg1: number): Vec3d;
        equals(arg0: any): boolean;
        abstract "get(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
        abstract "mirror(net.minecraft.core.Vec3i)"(arg0: Vec3i_): Vec3i;
        "compareTo(team.creative.creativecore.common.util.math.base.Axis)"(arg0: Internal.Axis_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.Axis
        static readonly Z: Internal.Axis;
        static readonly X: Internal.Axis;
        static readonly Y: Internal.Axis;
    }
    type Axis_ = "z" | "y" | "x" | Axis;
    interface IComponentProcessor {
        refresh(arg0: Internal.Screen_, arg1: number, arg2: number): void;
        allowRender(arg0: string): boolean;
        abstract process(arg0: Internal.Level_, arg1: string): Internal.IVariable;
        abstract setup(arg0: Internal.Level_, arg1: Internal.IVariableProvider_): void;
    }
    type IComponentProcessor_ = IComponentProcessor;
    class CarriageContraptionInstance extends Internal.EntityInstance<Internal.CarriageContraptionEntity> implements Internal.IUpdateCount, Internal.DynamicInstance {
        constructor(arg0: Internal.MaterialManager_, arg1: Internal.CarriageContraptionEntity_)
        getClass(): typeof any;
        railways$getUpdateCount(): number;
        decreaseFramerateWithDistance(): boolean;
        getInstancePosition(arg0: number): Vec3f;
        abstract isListenerInvalid(): boolean;
        getWorldPosition(): BlockPos;
        railways$markUpdate(): void;
        updateLight(): void;
        notify(): void;
        static outOfSync(a: Internal.IUpdateCount_, b: Internal.IUpdateCount_): boolean;
        wait(arg0: number, arg1: number): void;
        tickLightListener(): boolean;
        getInstancePosition(): Vec3f;
        remove(): void;
        railways$fromParent(parent: Internal.IUpdateCount_): void;
        onLightPacket(arg0: number, arg1: number): void;
        abstract onLightUpdate(arg0: Internal.LightLayer_, arg1: Internal.ImmutableBox_): void;
        toString(): string;
        init(): void;
        notifyAll(): void;
        beginFrame(): void;
        shouldReset(): boolean;
        getMaterialManager(): Internal.MaterialManager;
        hashCode(): number;
        removeAndMark(): void;
        update(): void;
        wait(): void;
        setBogeyVisibility(arg0: boolean, arg1: boolean): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        getVolume(): Internal.GridAlignedBB;
        get class(): typeof any
        get listenerInvalid(): boolean
        get worldPosition(): BlockPos
        get instancePosition(): Vec3f
        get materialManager(): Internal.MaterialManager
        get volume(): Internal.GridAlignedBB
    }
    type CarriageContraptionInstance_ = CarriageContraptionInstance;
    abstract class CustomRecipe implements Internal.CraftingRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.CraftingBookCategory_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        abstract matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        notify(): void;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        wait(arg0: number, arg1: number): void;
        abstract assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type CustomRecipe_ = CustomRecipe;
    class Chapter extends Internal.QuestObject {
        constructor(id: number, file: Internal.BaseQuestFile_, group: Internal.ChapterGroup_)
        constructor(id: number, file: Internal.BaseQuestFile_, group: Internal.ChapterGroup_, filename: string)
        consumeItems(): boolean;
        getRelativeProgressFromChildren(data: Internal.TeamData_): number;
        isCompletedRaw(data: Internal.TeamData_): boolean;
        writeData(nbt: Internal.CompoundTag_): void;
        getMutableTitle(): Internal.MutableComponent;
        isAlwaysInvisible(): boolean;
        getRawSubtitle(): Internal.List<string>;
        readData(nbt: Internal.CompoundTag_): void;
        editedFromGUI(): void;
        getIndex(): number;
        notify(): void;
        addImage(image: Internal.ChapterImage_): void;
        isAutofocus(id: number): boolean;
        getQuests(): Internal.List<Internal.Quest>;
        clearCachedData(): void;
        getRawTitle(): string;
        getDefaultQuestShape(): string;
        getProgressColor(data: Internal.TeamData_): Internal.Color4I;
        static isNull(object: Internal.QuestObjectBase_): boolean;
        removeQuest(quest: Internal.Quest_): void;
        cacheProgress(): boolean;
        deleteSelf(): void;
        getProgressionMode(): Internal.ProgressionMode;
        isRequireSequentialTasks(): boolean;
        isDefaultRepeatable(): boolean;
        getDefaultMinWidth(): number;
        static getID(object: Internal.QuestObjectBase_): number;
        componentsToRefresh(): Internal.Set<Internal.RecipeModHelper$Components>;
        hasUnclaimedRewardsRaw(teamData: Internal.TeamData_, player: Internal.UUID_): boolean;
        isValid(): boolean;
        onCompleted(data: Internal.QuestProgressEventData_<any>): void;
        static parseCodeString(id: string): number;
        setAutofocus(id: number): void;
        deleteChildren(): void;
        static getRelativeProgressFromChildren(progressSum: number, count: number): number;
        getTags(): Internal.Set<string>;
        forceProgress(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        getChildren(): Internal.Collection<Internal.QuestObject>;
        static "getCodeString(dev.ftb.mods.ftbquests.quest.QuestObjectBase)"(object: Internal.QuestObjectBase_): string;
        wait(): void;
        setRawIcon(rawIcon: Internal.ItemStack_): void;
        getTitle(): net.minecraft.network.chat.Component;
        static shouldSendNotifications(): boolean;
        getAutofocus(): Optional<Internal.Movable>;
        getAltIcon(): Internal.Icon;
        static titleToID(s: string): Optional<string>;
        onEditButtonClicked(gui: Internal.Runnable_): void;
        getClass(): typeof any;
        getProgressColor(data: Internal.TeamData_, dim: boolean): Internal.Color4I;
        static getCodeString(object: Internal.QuestObjectBase_): string;
        getCodeString(): string;
        static copy<T extends Internal.QuestObjectBase>(orig: T, factory: Internal.Supplier_<T>): T;
        hideQuestDetailsUntilStartable(): boolean;
        static getCodeString(id: number): string;
        hasAnyVisibleChildren(): boolean;
        isOptionalForProgression(): boolean;
        createSubGroup(group: Internal.ConfigGroup_): Internal.ConfigGroup;
        getParentID(): number;
        wait(arg0: number, arg1: number): void;
        fillConfigGroup(config: Internal.ConfigGroup_): void;
        setDefaultQuestShape(defaultQuestShape: string): void;
        getIcon(): Internal.Icon;
        addQuest(quest: Internal.Quest_): void;
        getFilename(): string;
        getAltTitle(): net.minecraft.network.chat.Component;
        static "getCodeString(long)"(id: number): string;
        readNetData(buffer: Internal.FriendlyByteBuf_): void;
        hasTag(tag: string): boolean;
        getQuestLinks(): Internal.List<Internal.QuestLink>;
        setRawTitle(rawTitle: string): void;
        toString(): string;
        onStarted(data: Internal.QuestProgressEventData_<any>): void;
        getDefaultQuestSize(): number;
        getQuestChapter(): this;
        notifyAll(): void;
        getQuestFile(): Internal.BaseQuestFile;
        getObjectType(): Internal.QuestObjectType;
        forceProgressRaw(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        addQuestLink(link: Internal.QuestLink_): void;
        removeImage(image: Internal.ChapterImage_): void;
        static parseHexId(id: string): Optional<number>;
        hashCode(): number;
        getPath(): Optional<string>;
        getImages(): Internal.List<Internal.ChapterImage>;
        writeNetData(buffer: Internal.FriendlyByteBuf_): void;
        isVisible(data: Internal.TeamData_): boolean;
        removeQuestLink(link: Internal.QuestLink_): void;
        editedFromGUIOnServer(): void;
        hasGroup(): boolean;
        onCreated(): void;
        wait(arg0: number): void;
        getGroup(): Internal.ChapterGroup;
        equals(object: any): boolean;
        hideQuestUntilDepsVisible(): boolean;
        get mutableTitle(): Internal.MutableComponent
        get alwaysInvisible(): boolean
        get rawSubtitle(): Internal.List<string>
        get index(): number
        get quests(): Internal.List<Internal.Quest>
        get rawTitle(): string
        get defaultQuestShape(): string
        get progressionMode(): Internal.ProgressionMode
        get requireSequentialTasks(): boolean
        get defaultRepeatable(): boolean
        get defaultMinWidth(): number
        get valid(): boolean
        set autofocus(id: number)
        get tags(): Internal.Set<string>
        get children(): Internal.Collection<Internal.QuestObject>
        set rawIcon(rawIcon: Internal.ItemStack_)
        get title(): net.minecraft.network.chat.Component
        get autofocus(): Optional<Internal.Movable>
        get altIcon(): Internal.Icon
        get class(): typeof any
        get codeString(): string
        get optionalForProgression(): boolean
        get parentID(): number
        set defaultQuestShape(defaultQuestShape: string)
        get icon(): Internal.Icon
        get filename(): string
        get altTitle(): net.minecraft.network.chat.Component
        get questLinks(): Internal.List<Internal.QuestLink>
        set rawTitle(rawTitle: string)
        get defaultQuestSize(): number
        get questChapter(): Internal.Chapter
        get questFile(): Internal.BaseQuestFile
        get objectType(): Internal.QuestObjectType
        get path(): Optional<string>
        get images(): Internal.List<Internal.ChapterImage>
        get group(): Internal.ChapterGroup
        readonly file: Internal.BaseQuestFile;
    }
    type Chapter_ = Chapter;
    class MutablePair <L, R> extends org.apache.commons.lang3.tuple.Pair<L, R> {
        constructor()
        constructor(arg0: L, arg1: R)
        getClass(): typeof any;
        getLeft(): L;
        static of<L, R>(arg0: L, arg1: R): Internal.MutablePair<L, R>;
        getRight(): R;
        compareTo(arg0: org.apache.commons.lang3.tuple.Pair_<L, R>): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        "compareTo(org.apache.commons.lang3.tuple.Pair)"(arg0: org.apache.commons.lang3.tuple.Pair_<L, R>): number;
        compareTo(arg0: any): number;
        static copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        static comparingByKey<K extends Internal.Comparable<any>, V>(): Comparator<Internal.Map$Entry<K, V>>;
        setRight(arg0: R): void;
        setLeft(arg0: L): void;
        toString(arg0: string): string;
        getKey(): L;
        static comparingByKey<K, V>(arg0: Comparator_<K>): Comparator<Internal.Map$Entry<K, V>>;
        toString(): string;
        notifyAll(): void;
        static emptyArray<L, R>(): Internal.MutablePair<L, R>[];
        getValue(): R;
        static comparingByValue<K, V extends Internal.Comparable<any>>(): Comparator<Internal.Map$Entry<K, V>>;
        hashCode(): number;
        static of<L, R>(arg0: Internal.Map$Entry_<L, R>): Internal.MutablePair<L, R>;
        wait(): void;
        wait(arg0: number): void;
        static comparingByValue<K, V>(arg0: Comparator_<V>): Comparator<Internal.Map$Entry<K, V>>;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        setValue(arg0: R): R;
        get class(): typeof any
        get left(): L
        get right(): R
        set right(arg0: R)
        set left(arg0: L)
        get key(): L
        get value(): R
        set value(arg0: R)
        left: L;
        right: R;
        static readonly EMPTY_ARRAY: Internal.MutablePair<any, any>[];
    }
    type MutablePair_<L, R> = MutablePair<L, R>;
    abstract class IntProvider {
        constructor()
        abstract getMinValue(): number;
        getClass(): typeof any;
        abstract sample(arg0: Internal.RandomSource_): number;
        toString(): string;
        abstract getMaxValue(): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract getType(): Internal.IntProviderType<any>;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        static codec(arg0: number, arg1: number): Internal.Codec<Internal.IntProvider>;
        static codec<T extends Internal.IntProvider>(arg0: number, arg1: number, arg2: Internal.Codec_<T>): Internal.Codec<T>;
        get minValue(): number
        get class(): typeof any
        get maxValue(): number
        get type(): Internal.IntProviderType<any>
        static readonly CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly NON_NEGATIVE_CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly POSITIVE_CODEC: Internal.Codec<Internal.IntProvider>;
    }
    type IntProvider_ = {max_inclusive: number, clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min_inclusive: number} | number | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, value: number} | {max_inclusive: number, clamped: Internal.IntProvider_, min_inclusive: number} | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min: number, max: number} | IntProvider | {clamped: Internal.IntProvider_, bounds: [number, number]} | {clamped: Internal.IntProvider_, min: number, max: number} | {value: number, clamped: Internal.IntProvider_} | [number, number] | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, bounds: [number, number]};
    class Intersection {
        constructor(arg0: Vec3d_, arg1: Internal.AABB_, arg2: Internal.FeatureType_, arg3: me.paulf.fairylights.server.feature.Feature_)
        getHitBox(): Internal.AABB;
        getClass(): typeof any;
        getFeature(): me.paulf.fairylights.server.feature.Feature;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        getResult(): Vec3d;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        getFeatureType(): Internal.FeatureType;
        get hitBox(): Internal.AABB
        get class(): typeof any
        get feature(): me.paulf.fairylights.server.feature.Feature
        get result(): Vec3d
        get featureType(): Internal.FeatureType
    }
    type Intersection_ = Intersection;
    class BrainDebugRenderer$PoiInfo {
        constructor(arg0: BlockPos_, arg1: string, arg2: number)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        type: string;
        readonly pos: BlockPos;
        freeTicketCount: number;
    }
    type BrainDebugRenderer$PoiInfo_ = BrainDebugRenderer$PoiInfo;
    class EspNBlock extends Internal.Block {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    }
    type EspNBlock_ = EspNBlock;
    class WirelessGridItem$Type extends Internal.Enum<Internal.WirelessGridItem$Type> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static values(): Internal.WirelessGridItem$Type[];
        name(): string;
        hashCode(): number;
        "compareTo(com.refinedmods.refinedstorage.item.WirelessGridItem$Type)"(arg0: Internal.WirelessGridItem$Type_): number;
        ordinal(): number;
        wait(): void;
        compareTo(arg0: Internal.WirelessGridItem$Type_): number;
        wait(arg0: number): void;
        static valueOf(arg0: string): Internal.WirelessGridItem$Type;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.WirelessGridItem$Type>>;
        getDeclaringClass(): typeof Internal.WirelessGridItem$Type;
        get class(): typeof any
        get declaringClass(): typeof Internal.WirelessGridItem$Type
        static readonly NORMAL: (Internal.WirelessGridItem$Type) & (Internal.WirelessGridItem$Type);
        static readonly CREATIVE: (Internal.WirelessGridItem$Type) & (Internal.WirelessGridItem$Type);
    }
    type WirelessGridItem$Type_ = WirelessGridItem$Type | "normal" | "creative";
    class IModFileInfo$LanguageSpec extends Internal.Record {
        constructor(languageName: string, acceptedVersions: Internal.VersionRange_)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        acceptedVersions(): Internal.VersionRange;
        wait(arg0: number): void;
        languageName(): string;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type IModFileInfo$LanguageSpec_ = IModFileInfo$LanguageSpec;
    class ContainerType extends Internal.Enum<Internal.ContainerType> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.ContainerType>>;
        getDeclaringClass(): typeof Internal.ContainerType;
        notifyAll(): void;
        static values(): Internal.ContainerType[];
        isEmpty(): boolean;
        compareTo(arg0: Internal.ContainerType_): number;
        notify(): void;
        isBlock(): boolean;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static valueOf(arg0: string): Internal.ContainerType;
        isFluid(): boolean;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        "compareTo(xfacthd.framedblocks.api.camo.ContainerType)"(arg0: Internal.ContainerType_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.ContainerType
        get empty(): boolean
        get block(): boolean
        get fluid(): boolean
        static readonly FLUID: (Internal.ContainerType) & (Internal.ContainerType);
        static readonly BLOCK: (Internal.ContainerType) & (Internal.ContainerType);
        static readonly EMPTY: (Internal.ContainerType) & (Internal.ContainerType);
    }
    type ContainerType_ = "fluid" | "block" | "empty" | ContainerType;
    class Method extends Internal.Executable {
        getClass(): typeof any;
        isVarArgs(): boolean;
        getAnnotatedParameterTypes(): Internal.AnnotatedType[];
        getGenericExceptionTypes(): Internal.Type[];
        getModifiers(): number;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        notify(): void;
        static setAccessible(arg0: Internal.AccessibleObject_[], arg1: boolean): void;
        wait(arg0: number, arg1: number): void;
        getAnnotatedReturnType(): Internal.AnnotatedType;
        getDefaultValue(): any;
        getParameterTypes(): typeof any[];
        getParameterAnnotations(): Internal.Annotation[][];
        getParameters(): any[];
        getName(): string;
        trySetAccessible(): boolean;
        getParameterCount(): number;
        invoke(arg0: any, ...arg1: any[]): any;
        getDeclaredAnnotations(): Internal.Annotation[];
        getAnnotatedReceiverType(): Internal.AnnotatedType;
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        getAnnotatedExceptionTypes(): Internal.AnnotatedType[];
        setAccessible(arg0: boolean): void;
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        toString(): string;
        getGenericParameterTypes(): Internal.Type[];
        notifyAll(): void;
        isSynthetic(): boolean;
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getTypeParameters(): any[];
        isDefault(): boolean;
        getDeclaringClass(): typeof any;
        getExceptionTypes(): typeof any[];
        hashCode(): number;
        getReturnType(): typeof any;
        canAccess(arg0: any): boolean;
        isBridge(): boolean;
        toGenericString(): string;
        wait(): void;
        getGenericReturnType(): Internal.Type;
        wait(arg0: number): void;
        getAnnotations(): Internal.Annotation[];
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        isAccessible(): boolean;
        get class(): typeof any
        get varArgs(): boolean
        get annotatedParameterTypes(): Internal.AnnotatedType[]
        get genericExceptionTypes(): Internal.Type[]
        get modifiers(): number
        get annotatedReturnType(): Internal.AnnotatedType
        get defaultValue(): any
        get parameterTypes(): typeof any[]
        get parameterAnnotations(): Internal.Annotation[][]
        get parameters(): any[]
        get name(): string
        get parameterCount(): number
        get declaredAnnotations(): Internal.Annotation[]
        get annotatedReceiverType(): Internal.AnnotatedType
        get annotatedExceptionTypes(): Internal.AnnotatedType[]
        set accessible(arg0: boolean)
        get genericParameterTypes(): Internal.Type[]
        get synthetic(): boolean
        get typeParameters(): any[]
        get "default"(): boolean
        get declaringClass(): typeof any
        get exceptionTypes(): typeof any[]
        get returnType(): typeof any
        get bridge(): boolean
        get genericReturnType(): Internal.Type
        get annotations(): Internal.Annotation[]
        /**
         * @deprecated
        */
        get accessible(): boolean
    }
    type Method_ = Method;
    class ImmutableCollections$SetN <E> extends Internal.ImmutableCollections$AbstractImmutableSet<E> implements Internal.Serializable {
        getClass(): typeof any;
        abstract add(arg0: E): boolean;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        toString(): string;
        forEach(arg0: Internal.Consumer_<E>): void;
        notifyAll(): void;
        toArray<T>(arg0: T[]): T[];
        "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        toArray(): any[];
        iterator(): Internal.Iterator<E>;
        hashCode(): number;
        size(): number;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static "of(java.lang.Object)"<E>(arg0: E): Internal.Set<E>;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableCollections$SetN_<E> = ImmutableCollections$SetN<E>;
    class DisplaySide extends Internal.Enum<Internal.DisplaySide> implements Internal.StringRepresentable {
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.DisplaySide[];
        getDeclaringClass(): typeof Internal.DisplaySide;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        "compareTo(net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide)"(arg0: Internal.DisplaySide_): number;
        static fromName(arg0: string): Internal.DisplaySide;
        previous(): this;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        toString(): string;
        notifyAll(): void;
        compareTo(arg0: Internal.DisplaySide_): number;
        name(): string;
        hashCode(): number;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.DisplaySide>>;
        ordinal(): number;
        wait(): void;
        next(): this;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        static valueOf(arg0: string): Internal.DisplaySide;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.DisplaySide
        static readonly FRONT: (Internal.DisplaySide) & (Internal.DisplaySide);
        static readonly LEFT: (Internal.DisplaySide) & (Internal.DisplaySide);
        static readonly RIGHT: (Internal.DisplaySide) & (Internal.DisplaySide);
    }
    type DisplaySide_ = "front" | "right" | DisplaySide | "left";
    interface CustomIngredientActionCallback {
        abstract transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.InventoryKJS_): Internal.ItemStack;
        (arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS): Internal.ItemStack_;
    }
    type CustomIngredientActionCallback_ = ((arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS)=> Internal.ItemStack_) | CustomIngredientActionCallback;
    class Locale$LanguageRange {
        constructor(arg0: string, arg1: number)
        constructor(arg0: string)
        getWeight(): number;
        getClass(): typeof any;
        toString(): string;
        static parse(arg0: string): Internal.List<Internal.Locale$LanguageRange>;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        static parse(arg0: string, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        static mapEquivalents(arg0: Internal.List_<Internal.Locale$LanguageRange>, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        getRange(): string;
        get weight(): number
        get class(): typeof any
        get range(): string
        static readonly MAX_WEIGHT: (1.0) & (number);
        static readonly MIN_WEIGHT: (0.0) & (number);
    }
    type Locale$LanguageRange_ = Locale$LanguageRange;
    interface ArtifactVersion extends Internal.Comparable<Internal.ArtifactVersion> {
        abstract compareTo(arg0: Internal.ArtifactVersion_): number;
        abstract getBuildNumber(): number;
        abstract parseVersion(arg0: string): void;
        abstract getMinorVersion(): number;
        abstract getMajorVersion(): number;
        abstract getIncrementalVersion(): number;
        abstract getQualifier(): string;
        get buildNumber(): number
        get minorVersion(): number
        get majorVersion(): number
        get incrementalVersion(): number
        get qualifier(): string
    }
    type ArtifactVersion_ = ArtifactVersion;
    interface ArgumentType <T> {
        abstract parse(arg0: Internal.StringReader_): T;
        getExamples(): Internal.Collection<string>;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        get examples(): Internal.Collection<string>
        (arg0: Internal.StringReader): T;
    }
    type ArgumentType_<T> = ((arg0: Internal.StringReader)=> T) | ArgumentType<T>;
    class ItemCooldowns implements Internal.AccessorItemCooldowns {
        constructor()
        getClass(): typeof any;
        toString(): string;
        bookshelf$getCooldowns(): Internal.Map<any, any>;
        notifyAll(): void;
        isOnCooldown(arg0: Internal.Item_): boolean;
        notify(): void;
        removeCooldown(arg0: Internal.Item_): void;
        wait(arg0: number, arg1: number): void;
        tick(): void;
        hashCode(): number;
        addCooldown(arg0: Internal.Item_, arg1: number): void;
        bookshelf$getTickCount(): number;
        wait(): void;
        getCooldownPercent(arg0: Internal.Item_, arg1: number): number;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type ItemCooldowns_ = ItemCooldowns;
    class Capability <T> {
        addListener(arg0: Internal.Consumer_<Internal.Capability<T>>): this;
        getClass(): typeof any;
        toString(): string;
        orEmpty<R>(arg0: Internal.Capability_<R>, arg1: Internal.LazyOptional_<T>): Internal.LazyOptional<R>;
        notifyAll(): void;
        isRegistered(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        getName(): string;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get registered(): boolean
        get name(): string
    }
    type Capability_<T> = Capability<T>;
    class StonecutterRecipe extends Internal.SingleItemRecipe {
        constructor(arg0: ResourceLocation_, arg1: string, arg2: Internal.Ingredient_, arg3: Internal.ItemStack_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type StonecutterRecipe_ = StonecutterRecipe;
    class DataPackEventJS extends Internal.EventJS {
        constructor(d: any_, rm: any_)
        getClass(): typeof any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        toString(): string;
        notifyAll(): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        hashCode(): number;
        wait(): void;
        add(id: ResourceLocation_, content: string): void;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        wait(arg0: number): void;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
        equals(arg0: any): boolean;
        addJson(id: ResourceLocation_, json: Internal.JsonElement_): void;
        get class(): typeof any
    }
    type DataPackEventJS_ = DataPackEventJS;
    class StackListResult <T> {
        constructor(arg0: T, arg1: Internal.UUID_, arg2: number)
        getClass(): typeof any;
        getStack(): T;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        getId(): Internal.UUID;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getChange(): number;
        get class(): typeof any
        get stack(): T
        get id(): Internal.UUID
        get change(): number
    }
    type StackListResult_<T> = StackListResult<T>;
    abstract class BunnyTailGreyItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getToughness(): number;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type BunnyTailGreyItem_ = BunnyTailGreyItem;
    class DoorControl extends Internal.Enum<Internal.DoorControl> {
        static createWidget(arg0: number, arg1: number, arg2: Internal.Consumer_<Internal.DoorControl>, arg3: Internal.DoorControl_): com.simibubi.create.foundation.utility.Pair<Internal.ScrollInput, Internal.Label>;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        static valueOf(arg0: string): Internal.DoorControl;
        "compareTo(com.simibubi.create.content.decoration.slidingDoor.DoorControl)"(arg0: Internal.DoorControl_): number;
        notifyAll(): void;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.DoorControl>>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static values(): Internal.DoorControl[];
        name(): string;
        hashCode(): number;
        getDeclaringClass(): typeof Internal.DoorControl;
        matches(arg0: Internal.Direction_): boolean;
        ordinal(): number;
        wait(): void;
        compareTo(arg0: Internal.DoorControl_): number;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.DoorControl
        static readonly SOUTH: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly NONE: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly WEST: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly ALL: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly NORTH: (Internal.DoorControl) & (Internal.DoorControl);
        static readonly EAST: (Internal.DoorControl) & (Internal.DoorControl);
    }
    type DoorControl_ = "west" | "east" | "south" | "north" | DoorControl | "none" | "all";
    class LanternBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Optional<Internal.SoundEvent>;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type LanternBlock_ = LanternBlock;
    interface Tier {
        /**
         * @deprecated
        */
        abstract getLevel(): number;
        abstract getRepairIngredient(): Internal.Ingredient;
        abstract getAttackDamageBonus(): number;
        abstract getEnchantmentValue(): number;
        abstract getUses(): number;
        abstract getSpeed(): number;
        getTag(): Internal.TagKey<Internal.Block>;
        /**
         * @deprecated
        */
        get level(): number
        get repairIngredient(): Internal.Ingredient
        get attackDamageBonus(): number
        get enchantmentValue(): number
        get uses(): number
        get speed(): number
        get tag(): Internal.TagKey<Internal.Block>
    }
    type Tier_ = string | Tier;
    class SlingshotItem extends Internal.ProjectileWeaponItem implements Internal.IThirdPersonAnimationProvider, Internal.Vanishable, Internal.IFirstPersonAnimationProvider {
        constructor(properties: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID(): Internal.UUID;
        moonlight$getClientAnimationExtension(): any;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        static getHeldProjectile(arg0: Internal.LivingEntity_, arg1: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID_$md$837fa8$0(): Internal.UUID;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        animateItemFirstPerson(entity: Internal.Player_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, arm: Internal.HumanoidArm_, poseStack: Internal.PoseStack_, partialTicks: number, pitch: number, attackAnim: number, handHeight: number): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        getClass(): typeof any;
        isTwoHanded(): boolean;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getDefaultProjectileRange(): number;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        crafttweaker$setRarity(arg0: Internal.Rarity_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(world: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        animateItemFirstPerson(entity: Internal.LivingEntity_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, matrixStack: Internal.PoseStack_, partialTicks: number, pitch: number, attackAnim: number, handHeight: number): void;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        static "attachToItem(net.minecraft.world.item.Item,net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider)"(target: Internal.Item_, object: Internal.IFirstPersonAnimationProvider_): void;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(stack: Internal.ItemStack_, world: Internal.Level_, entity: Internal.LivingEntity_, timeLeft: number): void;
        static animateCrossbowCharge(offHand: Internal.ModelPart_, mainHand: Internal.ModelPart_, entity: Internal.LivingEntity_, right: boolean): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(stack: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static get(target: Internal.Item_): Internal.IFirstPersonAnimationProvider;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        crafttweaker$setMaxStackSize(arg0: number): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        modifyReturnValue$ffi000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static crafttweaker$getBASE_ATTACK_DAMAGE_UUID(): Internal.UUID;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        static getChargeDuration(stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        static "attachToItem(net.minecraft.world.item.Item,net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider)"(target: Internal.Item_, object: Internal.IThirdPersonAnimationProvider_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): boolean;
        getUseAnimation(stack: Internal.ItemStack_): Internal.UseAnim;
        poseLeftArm<T extends Internal.LivingEntity>(stack: Internal.ItemStack_, model: Internal.HumanoidModel_<T>, entity: T, mainHand: Internal.HumanoidArm_): boolean;
        modifyReturnValue$ffi000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        getAllSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        static attachToItem(target: Internal.Item_, object: Internal.IThirdPersonAnimationProvider_): void;
        getSupportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        crafttweaker$setFireResistant(arg0: boolean): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        crafttweaker$setFoodProperties(arg0: Internal.FoodProperties_): void;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        getPowerForTime(stack: Internal.ItemStack_, timeLeft: number): number;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        poseRightArm<T extends Internal.LivingEntity>(stack: Internal.ItemStack_, model: Internal.HumanoidModel_<T>, entity: T, mainHand: Internal.HumanoidArm_): boolean;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        handler$fcd000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        crafttweaker$setMaxDamage(arg0: number): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        static attachToItem(target: Internal.Item_, object: Internal.IFirstPersonAnimationProvider_): void;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        getChargeSound(stack: Internal.ItemStack_): Internal.SoundEvent;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        static crafttweaker$getBASE_ATTACK_SPEED_UUID_$md$837fa8$1(): Internal.UUID;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get twoHanded(): boolean
        get renderPropertiesInternal(): any
        get defaultProjectileRange(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get allSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>
        get creativeTab(): string
        get supportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set attackDamage(attackDamage: number)
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
    }
    type SlingshotItem_ = SlingshotItem;
    class SporeBlossomBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type SporeBlossomBlock_ = SporeBlossomBlock;
    class PostPass implements Internal.AutoCloseable {
        constructor(arg0: Internal.ResourceManager_, arg1: string, arg2: Internal.RenderTarget_, arg3: Internal.RenderTarget_)
        getClass(): typeof any;
        setOrthoMatrix(arg0: Matrix4f_): void;
        process(arg0: number): void;
        toString(): string;
        notifyAll(): void;
        addAuxAsset(arg0: string, arg1: Internal.IntSupplier_, arg2: number, arg3: number): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        getName(): string;
        close(): void;
        getEffect(): Internal.EffectInstance;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        set orthoMatrix(arg0: Matrix4f_)
        get name(): string
        get effect(): Internal.EffectInstance
        readonly outTarget: Internal.RenderTarget;
        readonly inTarget: Internal.RenderTarget;
    }
    type PostPass_ = PostPass;
    class ClientboundTagQueryPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number, arg1: Internal.CompoundTag_)
        handle(arg0: Internal.PacketListener_): void;
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        notifyAll(): void;
        getTransactionId(): number;
        notify(): void;
        isSkippable(): boolean;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        wait(arg0: number): void;
        "handle(net.minecraft.network.protocol.game.ClientGamePacketListener)"(arg0: Internal.ClientGamePacketListener_): void;
        getTag(): Internal.CompoundTag;
        equals(arg0: any): boolean;
        "handle(net.minecraft.network.PacketListener)"(arg0: Internal.PacketListener_): void;
        get class(): typeof any
        get transactionId(): number
        get skippable(): boolean
        get tag(): Internal.CompoundTag
    }
    type ClientboundTagQueryPacket_ = ClientboundTagQueryPacket;
    interface BufferedImageOp {
        abstract createCompatibleDestImage(arg0: Internal.BufferedImage_, arg1: Internal.ColorModel_): Internal.BufferedImage;
        abstract filter(arg0: Internal.BufferedImage_, arg1: Internal.BufferedImage_): Internal.BufferedImage;
        abstract getBounds2D(arg0: Internal.BufferedImage_): Internal.Rectangle2D;
        abstract getPoint2D(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        abstract getRenderingHints(): Internal.RenderingHints;
        get renderingHints(): Internal.RenderingHints
    }
    type BufferedImageOp_ = BufferedImageOp;
    class HitResult$Type extends Internal.Enum<Internal.HitResult$Type> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getDeclaringClass(): typeof Internal.HitResult$Type;
        getClass(): typeof any;
        toString(): string;
        "compareTo(net.minecraft.world.phys.HitResult$Type)"(arg0: Internal.HitResult$Type_): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static valueOf(arg0: string): Internal.HitResult$Type;
        describeConstable(): Optional<Internal.Enum$EnumDesc<Internal.HitResult$Type>>;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.HitResult$Type[];
        compareTo(arg0: Internal.HitResult$Type_): number;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get declaringClass(): typeof Internal.HitResult$Type
        get class(): typeof any
        static readonly MISS: (Internal.HitResult$Type) & (Internal.HitResult$Type);
        static readonly ENTITY: (Internal.HitResult$Type) & (Internal.HitResult$Type);
        static readonly BLOCK: (Internal.HitResult$Type) & (Internal.HitResult$Type);
    }
    type HitResult$Type_ = "miss" | "block" | HitResult$Type | "entity";
    class SynchedEntityData$DataValue <T> extends Internal.Record {
        constructor(id: number, serializer: Internal.EntityDataSerializer_<T>, value: T)
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        notifyAll(): void;
        value(): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        id(): number;
        wait(): void;
        serializer(): Internal.EntityDataSerializer<T>;
        wait(arg0: number): void;
        static create<T>(arg0: Internal.EntityDataAccessor_<T>, arg1: T): Internal.SynchedEntityData$DataValue<T>;
        static read(arg0: Internal.FriendlyByteBuf_, arg1: number): Internal.SynchedEntityData$DataValue<any>;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type SynchedEntityData$DataValue_<T> = SynchedEntityData$DataValue<T>;
    abstract class ImmutableList <E> extends Internal.ImmutableCollection<E> implements Internal.RandomAccess, Internal.List<E> {
        static builder<E>(): Internal.ImmutableList$Builder<E>;
        static copyOf<E>(arg0: E[]): Internal.ImmutableList<E>;
        reverse(): this;
        static sortedCopyOf<E>(arg0: Comparator_<E>, arg1: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        sort(arg0: Comparator_<E>): void;
        notify(): void;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        "remove(int)"(arg0: number): E;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        /**
         * @deprecated
        */
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        listIterator(): Internal.ListIterator<any>;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableList<E>;
        indexOf(arg0: any): number;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableList<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static "of(java.lang.Object)"<E>(arg0: E): Internal.ImmutableList<E>;
        abstract remove(arg0: any): boolean;
        abstract "remove(java.lang.Object)"(arg0: any): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.ImmutableList<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        wait(): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static "copyOf(java.lang.Iterable)"<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.List<E>;
        lastIndexOf(arg0: any): number;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableList<E>;
        getClass(): typeof any;
        abstract get(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.ImmutableList<E>;
        static "copyOf(java.util.Collection)"<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        abstract add(arg0: E): boolean;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.ImmutableList<E>;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        wait(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E, arg11: E, ...arg12: E[]): Internal.ImmutableList<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.ImmutableList<E>;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableList$Builder<E>;
        static of<E>(): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        remove(arg0: number): E;
        static of<E>(arg0: E): Internal.ImmutableList<E>;
        contains(arg0: any): boolean;
        static "copyOf(java.util.Iterator)"<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.ImmutableList<E>;
        toString(): string;
        iterator(): Internal.Iterator<any>;
        notifyAll(): void;
        static sortedCopyOf<E extends Internal.Comparable<any>>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static "copyOf(java.lang.Object[])"<E>(arg0: E[]): Internal.ImmutableList<E>;
        abstract "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E): Internal.ImmutableList<E>;
        abstract toArray(): any[];
        /**
         * @deprecated
        */
        asList(): this;
        subList(arg0: number, arg1: number): Internal.List<any>;
        hashCode(): number;
        abstract size(): number;
        static toImmutableList<E>(): Internal.Collector<E, any, Internal.ImmutableList<E>>;
        abstract clear(): void;
        wait(arg0: number): void;
        spliterator(): Internal.Spliterator<E>;
        equals(arg0: any): boolean;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableList<E>;
        get class(): typeof any
        get empty(): boolean
    }
    type ImmutableList_<E> = ImmutableList<E>;
    class LBhombresBlock extends Internal.Block {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        crafttweaker$getHasCollision(): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getProperties(): Internal.BlockBehaviour$Properties;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        get properties(): Internal.BlockBehaviour$Properties
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    }
    type LBhombresBlock_ = LBhombresBlock;
    /**
     * Methods for working with Java classes. Reflection my beloved ♥
    */
    class JavaWrapper {
        constructor(manager: any_)
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeItem"): Internal.IForgeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.beachparty.item.armor.DyeableBeachpartyArmorItem"): typeof Internal.DyeableBeachpartyArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket"): typeof Internal.ClientboundInitializeBorderPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.FlavorMap"): Internal.FlavorMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SignText"): typeof Internal.SignText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.core.util.SetableSupplier"): typeof Internal.SetableSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.Consumer"): Internal.Consumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RepairItemRecipe"): typeof Internal.RepairItemRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MudBlock"): typeof Internal.MudBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.builders.CubeDefinition"): typeof Internal.CubeDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.almostreliable.morejs.features.villager.TradeTypes"): typeof Internal.TradeTypes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.gossip.GossipType"): typeof Internal.GossipType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.EspBBlock"): typeof Internal.EspBBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.BasicMobEffect$Builder"): typeof Internal.BasicMobEffect$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.api.mana.ManaPool"): Internal.ManaPool;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockBuilder"): typeof Internal.BlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootContext$EntityTarget"): typeof Internal.LootContext$EntityTarget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer"): typeof Internal.MultiTextureRenderTypeRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BunnyTailBrownItem"): typeof Internal.BunnyTailBrownItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.spi.LoggerContextShutdownEnabled"): Internal.LoggerContextShutdownEnabled;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceRules$RuleSource"): Internal.SurfaceRules$RuleSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.maxhenkel.gravestone.corelib.death.Death"): typeof Internal.Death;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.info.render.InfoDisplayRenderer"): typeof Internal.InfoDisplayRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.drawable.IDrawable"): Internal.IDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.fan.processing.FanProcessingType$AirFlowParticleAccess"): Internal.FanProcessingType$AirFlowParticleAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.api.mana.CompositableLensItem"): Internal.CompositableLensItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.ingredients.IIngredientTypeWithSubtypes"): Internal.IIngredientTypeWithSubtypes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.InputReplacement"): Internal.InputReplacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.ScheduledTick"): typeof Internal.ScheduledTick;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ExperienceBottleItem"): typeof Internal.ExperienceBottleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.BlockPos"): typeof BlockPos;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.MinecraftProfileTexture"): typeof Internal.MinecraftProfileTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerTrades$TreasureMapForEmeralds"): typeof Internal.VillagerTrades$TreasureMapForEmeralds;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.BaseMapCodec"): Internal.BaseMapCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ThirdPartyServerInfo"): typeof Internal.AbuseReportRequest$ThirdPartyServerInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmeltingUpgradeItem"): typeof Internal.SmeltingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock"): typeof Internal.AbstractRopeKnotBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2FloatFunction"): Internal.Long2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarverDebugSettings"): typeof Internal.CarverDebugSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fuzs.puzzleslib.mixin.accessor.BiomeSpecialEffectsBuilderForgeAccessor"): Internal.BiomeSpecialEffectsBuilderForgeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.light.LightVolume"): typeof Internal.LightVolume;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$OverlayStateShard"): typeof Internal.RenderStateShard$OverlayStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.permission.events.PermissionGatherEvent"): typeof Internal.PermissionGatherEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BooleanProperty"): typeof Internal.BooleanProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.ExplosionEventJS$After"): typeof Internal.ExplosionEventJS$After;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.ToallarojacolgBlock"): typeof Internal.ToallarojacolgBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.event.api.OPACServerAddonRegisterEvent"): typeof Internal.OPACServerAddonRegisterEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.feet.KittySlippersItem"): typeof Internal.KittySlippersItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.chaosthedude.naturescompass.items.NaturesCompassItem"): typeof Internal.NaturesCompassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.item.ItemHemolymphBlaster"): typeof Internal.ItemHemolymphBlaster;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DiscFragmentItem"): typeof Internal.DiscFragmentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.RegularImmutableMap"): typeof Internal.RegularImmutableMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.BiPredicate"): Internal.BiPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.LiteralCommandNode"): typeof Internal.LiteralCommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.InputEvent$MouseButton$Pre"): typeof Internal.InputEvent$MouseButton$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.NonNullSupplier"): Internal.NonNullSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.orlouge.nomobfarm.MobDeathScoreAlgorithm"): typeof Internal.MobDeathScoreAlgorithm;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2LongFunction"): Internal.Double2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SculkSensorBlockEntity"): typeof Internal.SculkSensorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.gui.MyOptions"): typeof Internal.MyOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Vex"): typeof Internal.Vex;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.ResourceManagerReloadListener"): Internal.ResourceManagerReloadListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.LevelTicks"): typeof Internal.LevelTicks;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.LiquidBlockRenderer"): typeof Internal.LiquidBlockRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator"): typeof Internal.VariantBlockStateGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.layers.RenderLayer"): typeof Internal.RenderLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FireBlock"): typeof Internal.FireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.gui.widget.WidgetLoadingHandler"): typeof Internal.WidgetLoadingHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.api.event.UsageTickerEvent$GetCount"): typeof Internal.UsageTickerEvent$GetCount;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.common.gui.flow.GuiFlowFitX"): typeof Internal.GuiFlowFitX;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.gui.IScreenBase"): xaero.common.gui.IScreenBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.BeaconMenu"): typeof Internal.BeaconMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.minecart.MinecartCouplingItem"): typeof Internal.MinecartCouplingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.waypoints.render.CompassRenderer"): typeof Internal.CompassRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.deallocator.ByteBufferDeallocator"): typeof Internal.ByteBufferDeallocator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.coderbot.batchedentityrendering.mixin.OutlineBufferSourceAccessor"): Internal.OutlineBufferSourceAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.shapes.VoxelShapeCaster"): Internal.VoxelShapeCaster;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.common.item.BagItem"): typeof Internal.BagItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.talrey.createdeco.items.RailingBlockItem"): typeof Internal.RailingBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.Pack$Position"): typeof Internal.Pack$Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation"): Internal.ILimitedGlobalStation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ItemCombinerMenu"): typeof Internal.ItemCombinerMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.mixin.PausedPartialTickAccessor"): Internal.PausedPartialTickAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapDecoder"): Internal.MapDecoder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockItem"): typeof Internal.ModularAccumulatorBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$SidesType"): typeof Internal.JobAttributes$SidesType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.BiomeSpecialEffectsBuilder"): typeof Internal.BiomeSpecialEffectsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$PlayerLoggedOutEvent"): typeof Internal.PlayerEvent$PlayerLoggedOutEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.waypoints.render.WaypointFilterParams"): typeof Internal.WaypointFilterParams;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.forge.mixin.client.ModelBakeryForgeAccessor"): Internal.ModelBakeryForgeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SignBlock"): typeof Internal.SignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.SliceMapItem$DepthMapData"): typeof Internal.SliceMapItem$DepthMapData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.atomic.AtomicReference"): typeof Internal.AtomicReference;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.GiantTrunkPlacer"): typeof Internal.GiantTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.task.TaskType"): typeof Internal.TaskType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.StringRepresentable$EnumCodec"): typeof Internal.StringRepresentable$EnumCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ServerLevelAccessor"): Internal.ServerLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.paulf.fairylights.server.feature.light.Light"): typeof Internal.Light;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.trading.MerchantOffer"): typeof Internal.MerchantOffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.compat.computercraft.AbstractComputerBehaviour"): typeof Internal.AbstractComputerBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.pavocado.exoticbirds.item.BirdcageItem"): typeof Internal.BirdcageItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType$1"): typeof Internal.RecipeType$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonTakeoffPhase"): typeof Internal.DragonTakeoffPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder$DrawState"): typeof Internal.BufferBuilder$DrawState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.util.ZetaSide"): typeof Internal.ZetaSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer"): typeof Internal.BendingTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.NetherForestVegetationFeature"): typeof Internal.NetherForestVegetationFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.LightTexture"): typeof Internal.LightTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.mixin.MouseHandlerAccessor"): team.creative.creativecore.mixin.MouseHandlerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SnowballItem"): typeof Internal.SnowballItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem"): typeof Internal.DepositUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "thetadev.constructionwand.basics.option.WandOptions$DIRECTION"): typeof Internal.WandOptions$DIRECTION;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket"): typeof Internal.ClientboundBlockChangedAckPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment"): typeof Internal.BackstabbingEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$PostType"): typeof Internal.ModBlockProperties$PostType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.matyrobbrt.mobcapturingtool.item.CapturingToolItem"): typeof Internal.CapturingToolItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4i"): typeof Internal.Vector4i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.MinecartChest"): typeof Internal.MinecartChest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.config.type.IBiomeConfig"): Internal.IBiomeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragGestureListener"): Internal.DragGestureListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.network.ZetaMessageSerializer"): typeof Internal.ZetaMessageSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.logistics.funnel.FunnelItem"): typeof Internal.FunnelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Insets"): typeof Internal.Insets;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedBlockExtension"): Internal.InjectedBlockExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zetaimplforge.mixin.mixins.client.AccessorItemColors"): Internal.AccessorItemColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings"): typeof Internal.MobSpawnSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.IArmPoseTransformer"): Internal.IArmPoseTransformer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.entity.movement_tracker.MovementTrackerCache"): Internal.MovementTrackerCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.mixin.PistonBaseBlockAccessor"): Internal.PistonBaseBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$Parameter"): typeof Internal.Climate$Parameter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PotatoBlock"): typeof Internal.PotatoBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleSelection"): Internal.AccessibleSelection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.fluid.HotChocolateFluid"): typeof Internal.HotChocolateFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.BabetoscBlock"): typeof Internal.BabetoscBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xfacthd.framedblocks.api.camo.CamoContainer$Factory"): typeof Internal.CamoContainer$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.RedPlaidSkirtItem$Boots"): typeof Internal.RedPlaidSkirtItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.cristelknight.doapi.common.item.CustomArmorItem"): typeof Internal.CustomArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.LoggedChatEvent$Type"): typeof Internal.LoggedChatEvent$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.gui.dropdown.DropDownWidget"): typeof Internal.DropDownWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket"): typeof Internal.ClientboundUpdateMobEffectPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue"): typeof Internal.RecipeComponentValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern"): Internal.ICraftingPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$ItemSmeltedEvent"): typeof Internal.PlayerEvent$ItemSmeltedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfyu.vinery.effect.LuckEffect"): typeof Internal.LuckEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.SensorType"): typeof Internal.SensorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.coderbot.batchedentityrendering.mixin.RenderStateShardAccessor"): Internal.RenderStateShardAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.kosmx.emotes.common.network.EmotePacket$Builder"): typeof Internal.EmotePacket$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.Pandarix.beautify.core.init.ItemInit$28"): typeof Internal.ItemInit$28;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_model_features.models.EMFModelPartVanilla"): typeof Internal.EMFModelPartVanilla;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.block.IZetaBlock"): Internal.IZetaBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.TickContainerAccess"): Internal.TickContainerAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.beachparty.item.IBeachpartyArmorSet"): Internal.IBeachpartyArmorSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BeaconBlockEntity"): typeof Internal.BeaconBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.ILavaAndWaterLoggable"): Internal.ILavaAndWaterLoggable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.CustomBuffer"): typeof Internal.CustomBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomTaskEventJS"): typeof Internal.CustomTaskEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.Material"): typeof Internal.Material;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.CreateConfectioneryIconItem"): typeof Internal.CreateConfectioneryIconItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedGameEventExtension"): Internal.InjectedGameEventExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.world.MapConnectionManager"): typeof Internal.MapConnectionManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.core.layout.BufferLayout$Builder"): typeof Internal.BufferLayout$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem"): typeof Internal.BatteryUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator$Part"): typeof Internal.MultipartBlockStateGenerator$Part;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Targeting"): Internal.Targeting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.Logger"): org.apache.logging.log4j.Logger;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.font.glyphs.BakedGlyph$Effect"): typeof Internal.BakedGlyph$Effect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaeroplus.mixin.client.MixinWidgetScreenHandlerAccessor"): Internal.MixinWidgetScreenHandlerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.coderbot.iris.vertices.ExtendingBufferBuilder"): Internal.ExtendingBufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.client.model.forge.ExtraModelDataImpl"): typeof Internal.ExtraModelDataImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.settings.ModOptions"): typeof Internal.ModOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownPotion"): typeof Internal.ThrownPotion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.resources.FileToIdConverter"): typeof Internal.FileToIdConverter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2LongMap"): Internal.Long2LongMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.Boat"): typeof Internal.Boat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.LootItemConditionType"): typeof Internal.LootItemConditionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableMultimap"): typeof Internal.ImmutableMultimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GreySkirtItem$Leggings"): typeof Internal.GreySkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem"): typeof Internal.SequencedAssemblyItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem"): typeof Internal.ManasteelArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.InstrumentItem"): typeof Internal.InstrumentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Hashtable"): typeof Internal.Hashtable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.item.HookItem"): typeof Internal.HookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.GuiMessage$Line"): typeof Internal.GuiMessage$Line;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.DrinkableItem"): typeof Internal.DrinkableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BedItem"): typeof Internal.BedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.beachparty.item.armor.BeachpartyCustomArmorItem"): typeof Internal.BeachpartyCustomArmorItem;
        /**
         * Creates a custom ConsoleJS instance for you to use to, well, log stuff
        */
        createConsole(name: string): Internal.ConsoleJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SpawnEggItem"): typeof Internal.SpawnEggItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeManager"): typeof Internal.BiomeManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.ChristmasElfAttireMaleGreenItem$Chestplate"): typeof Internal.ChristmasElfAttireMaleGreenItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.locks.Lock"): Internal.Lock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.maxhenkel.camera.items.ImageFrameItem"): typeof Internal.ImageFrameItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.integration.RecipeModHelper$Components"): typeof Internal.RecipeModHelper$Components;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.multistate.IMultiStateItemStack"): Internal.IMultiStateItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldgenRandom"): typeof Internal.WorldgenRandom;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.paulf.fairylights.server.fastener.accessor.FastenerAccessor"): Internal.FastenerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GreenPlaidSkirtItem$Boots"): typeof Internal.GreenPlaidSkirtItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour"): typeof Internal.BeltProcessingBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.category.ui.entry.ConnectionLineType"): typeof Internal.ConnectionLineType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbteams.kubejs.PlayerTeamEventJS"): typeof Internal.PlayerTeamEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.paulf.fairylights.util.Curve$SegmentIterator"): Internal.Curve$SegmentIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.lion.villagersplus.util.DuckBucketable"): Internal.DuckBucketable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.block.BlockColors"): typeof Internal.BlockColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.talrey.createdeco.items.CatwalkBlockItem"): typeof Internal.CatwalkBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.ILightable"): Internal.ILightable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2CharFunction"): Internal.Short2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.RoyalTunicLightBlueItem$Chestplate"): typeof Internal.RoyalTunicLightBlueItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2FloatFunction"): Internal.Double2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem"): typeof com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.GraphicsDevice"): typeof Internal.GraphicsDevice;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$KeyReleased"): typeof Internal.ScreenEvent$KeyReleased;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.citadel.server.world.ExpandedBiomeSource"): Internal.ExpandedBiomeSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.WallBlockBuilder"): typeof Internal.WallBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.mixin.mixins.IZetaItemExtensionsMixin"): Internal.IZetaItemExtensionsMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.module.ZetaModuleManager"): typeof Internal.ZetaModuleManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.IExtendedPistonTile"): Internal.IExtendedPistonTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.EditBox"): typeof Internal.EditBox;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mcwfurnitures.kikoz.objects.ItemBlock"): typeof Internal.ItemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.spectator.SpectatorGui"): typeof Internal.SpectatorGui;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.world.chunk.ChunkHolderExtended"): Internal.ChunkHolderExtended;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.builder.IRecipeLayoutBuilder"): Internal.IRecipeLayoutBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.api.IItemFilter"): Internal.IItemFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SpawnerBlock"): typeof Internal.SpawnerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.TridentRiptideEnchantment"): typeof Internal.TridentRiptideEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PrimitiveIterator$OfDouble"): Internal.PrimitiveIterator$OfDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.commons.lang3.mutable.MutableBoolean"): typeof Internal.MutableBoolean;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor"): typeof Internal.BlockAgeProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SeaPickleFeature"): typeof Internal.SeaPickleFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.ChristmasElfAttireMaleGreenItem"): typeof Internal.ChristmasElfAttireMaleGreenItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.betterjungletemples.mixin.accessor.WorldGenRegionAccessor"): Internal.WorldGenRegionAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfyu.herbalbrews.items.TooltipItem"): typeof satisfyu.herbalbrews.items.TooltipItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.Lazy"): typeof Internal.Lazy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules"): typeof Internal.GameRules;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BookItem"): typeof Internal.BookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer$Builder"): typeof Internal.LootPoolEntryContainer$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractChestedHorse"): Internal.AccessorAbstractChestedHorse;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.DamageScaling"): typeof Internal.DamageScaling;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ArrowKnockbackEnchantment"): typeof Internal.ArrowKnockbackEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffect"): typeof Internal.MobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.InputType"): typeof Internal.InputType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CalibratedSculkSensorBlock"): typeof Internal.CalibratedSculkSensorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BellBlock"): typeof Internal.BellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.MaleClausAttireItem$Boots"): typeof Internal.MaleClausAttireItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PowderSnowCauldronBlock"): typeof Internal.PowderSnowCauldronBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.FishingHook"): typeof Internal.FishingHook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K1"): Internal.K1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GameEventListenerRenderer"): typeof Internal.GameEventListenerRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ReferenceMap$Entry"): Internal.Object2ReferenceMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ht.treechop.common.properties.ChoppedLogShape"): typeof Internal.ChoppedLogShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerDestroyItemEvent"): typeof Internal.PlayerDestroyItemEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FurnaceBlock"): typeof Internal.FurnaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ObjectFunction"): Internal.Char2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xfacthd.framedblocks.api.camo.CamoContainer"): typeof Internal.CamoContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BunnyTailOrangeItem"): typeof Internal.BunnyTailOrangeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour"): Internal.BlueprintCopyBehaviour;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.templates.TaggedChoice$TaggedChoiceType"): typeof Internal.TaggedChoice$TaggedChoiceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleToIntFunction"): Internal.DoubleToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS"): typeof Internal.BlockStateMirrorCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.SugarCubeItem"): typeof Internal.SugarCubeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.GoldTrapdoorBlock"): typeof Internal.GoldTrapdoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver"): typeof Internal.ConfiguredWorldCarver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.DaylightDetectorBlockEntity"): typeof Internal.DaylightDetectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock"): typeof Internal.FaucetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.tool.IUnsealItem"): Internal.IUnsealItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentHashMap$KeySetView"): typeof Internal.ConcurrentHashMap$KeySetView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.IContainerFactory"): Internal.IContainerFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.extensions.common.IClientBlockExtensions"): Internal.IClientBlockExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.SecondaryPoiSensor"): typeof Internal.SecondaryPoiSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.BiomeGenerationSettingsBuilder"): typeof Internal.BiomeGenerationSettingsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable"): Internal.IControllerBoundable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.WithPersistentData"): Internal.WithPersistentData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.core.impl.LocationAware"): Internal.LocationAware;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$ParameterPoint"): typeof Internal.Climate$ParameterPoint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.syncher.EntityDataAccessor"): typeof Internal.EntityDataAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$CullStateShard"): typeof Internal.RenderStateShard$CullStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.item.PrimedTnt"): typeof Internal.PrimedTnt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.QuestShape"): typeof Internal.QuestShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket"): typeof Internal.ClientboundSectionBlocksUpdatePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_model_features.models.EMFModelPart"): typeof Internal.EMFModelPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.content.tools.item.SeedPouchItem$PouchContents"): typeof Internal.SeedPouchItem$PouchContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BlackSkirtItem$Leggings"): typeof Internal.BlackSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeBlock"): Internal.IForgeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.ArrivalSoundQueue"): typeof Internal.ArrivalSoundQueue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.WanderingTrader"): typeof Internal.WanderingTrader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Cow"): typeof Internal.Cow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.api.IMutableAdvancement"): Internal.IMutableAdvancement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.brnbrd.delightful.common.item.knife.compat.aether.ZaniteKnifeItem"): typeof Internal.ZaniteKnifeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.ingredients.subtypes.UidContext"): typeof Internal.UidContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.task.TaskType$GuiProvider"): Internal.TaskType$GuiProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.JabonBlock"): typeof Internal.JabonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider"): Internal.IStorageDiskProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.element.render.MinimapElementRenderer"): typeof Internal.MinimapElementRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.WritableRenderedImage"): Internal.WritableRenderedImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec"): typeof Internal.ForgeConfigSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FarmBlock"): typeof Internal.FarmBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "eutros.framedcompactdrawers.item.ItemDrawersCustom"): typeof Internal.ItemDrawersCustom;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.stream.JsonToken"): typeof Internal.JsonToken;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.claims.result.api.ClaimResult$Type"): typeof Internal.ClaimResult$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.Attribute"): typeof Internal.Attribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock"): typeof Internal.BambooSpikesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BrownPlaidSkirtItem$Leggings"): typeof Internal.BrownPlaidSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.LBBdiscapacitadosBlock"): typeof Internal.LBBdiscapacitadosBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.WindowListener"): Internal.WindowListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature"): typeof Internal.MultifaceGrowthFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.io.Serializable"): Internal.Serializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.BlockModel"): typeof Internal.BlockModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.util.zetalist.IZeta"): Internal.IZeta;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Function16"): Internal.Function16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeWrapper"): typeof Internal.InceptionUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI"): Internal.IPlayerConfigClientStorageAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.ModifiableStructureInfo"): typeof Internal.ModifiableStructureInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS"): typeof Internal.AfterEntityFallenOnBlockCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Rectangle"): typeof Internal.Rectangle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.block.BlockTriopsEggs"): typeof Internal.BlockTriopsEggs;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.gamestages.event.GameStageEvent$Removed"): typeof Internal.GameStageEvent$Removed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionProgress"): typeof Internal.CriterionProgress;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PermissionsChangedEvent"): typeof Internal.PermissionsChangedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.relic.KeyOfTheKingsLawItem"): typeof Internal.KeyOfTheKingsLawItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem"): typeof Internal.VoidUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.candlelight.item.armor.CookBootsItem"): typeof Internal.CookBootsItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelStorageSource"): typeof Internal.LevelStorageSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.brnbrd.delightful.common.item.food.HoneyGlazedWalnutItem"): typeof Internal.HoneyGlazedWalnutItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.AbstractSelectionList$Entry"): typeof Internal.AbstractSelectionList$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.region.MinimapChunk"): typeof Internal.MinimapChunk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderType$CompositeRenderType"): typeof Internal.RenderType$CompositeRenderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "malte0811.ferritecore.mixin.blockstatecache.VoxelShapeAccess"): Internal.VoxelShapeAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ProfileResults"): Internal.ProfileResults;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Zombie"): typeof Internal.Zombie;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.AllOfCondition$Builder"): typeof Internal.AllOfCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.bauble.BandOfAuraItem"): typeof Internal.BandOfAuraItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.LocalDate"): typeof Internal.LocalDate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Key"): typeof Internal.GameRules$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.LootTableEntry"): typeof Internal.LootTableEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType"): typeof Internal.BlockStateProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.CombatTracker"): typeof Internal.CombatTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderLevelStageEvent$RegisterStageEvent"): typeof Internal.RenderLevelStageEvent$RegisterStageEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BunnyTailWhiteItem$Chestplate"): typeof Internal.BunnyTailWhiteItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.RelayerBlock"): typeof Internal.RelayerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.SpellbindingClothItem"): typeof Internal.SpellbindingClothItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket"): typeof Internal.ClientboundSetBorderSizePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.registries.DeferredSupplier"): Internal.DeferredSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectList"): Internal.ObjectList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuCategory"): Internal.SpectatorMenuCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2DoubleFunction"): Internal.Double2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder"): typeof Internal.ShapedBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration"): typeof Internal.MultifaceGrowthConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mcwroofs.kikoz.util.FuelItemBlock"): typeof com.mcwroofs.kikoz.util.FuelItemBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.mutator.IGenerallyModifiableAreaMutator"): Internal.IGenerallyModifiableAreaMutator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RedstoneLampBlock"): typeof Internal.RedstoneLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity"): typeof Internal.TheEndGatewayBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Symbol"): Internal.Symbol;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.OptionalLong"): typeof Internal.OptionalLong;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GreenKnightArmourItem$Leggings"): typeof Internal.GreenKnightArmourItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.ChristmasElfAttireRedMaleItem"): typeof Internal.ChristmasElfAttireRedMaleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.BookPage"): typeof Internal.BookPage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.ReportEnvironment"): typeof Internal.ReportEnvironment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin.AccessorBlockEntityType"): Internal.AccessorBlockEntityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.MenuProvider"): Internal.MenuProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.UrnBlock"): typeof Internal.UrnBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "snownee.snow.mixin.IntegerValueAccess"): Internal.IntegerValueAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.NetherWorldCarver"): typeof Internal.NetherWorldCarver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket"): typeof Internal.ClientboundSetTitleTextPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.waypoints.WaypointsManager"): typeof Internal.WaypointsManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.brnbrd.delightful.common.item.knife.compat.spirit.SoulSteelKnifeItem"): typeof Internal.SoulSteelKnifeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI"): Internal.IClaimsManagerListenerAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.capability.ZetaCapability"): typeof Internal.ZetaCapability;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator"): Internal.Spliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockLeftClickedEventJS"): typeof Internal.BlockLeftClickedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "traben.entity_model_features.models.IEMFModelNameContainer"): Internal.IEMFModelNameContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "shcm.shsupercm.forge.citresewn.pack.cits.CITEnchantment"): typeof Internal.CITEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.ProjectileImpactEvent$ImpactResult"): typeof Internal.ProjectileImpactEvent$ImpactResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.DataResult"): typeof Internal.DataResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionContainer"): Internal.ConditionContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.impl.ItemPropertiesExtensionImpl"): Internal.ItemPropertiesExtensionImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.common.util.registry.NamedHandlerRegistry"): typeof Internal.NamedHandlerRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.gossip.GossipContainer$EntityGossips"): typeof Internal.GossipContainer$EntityGossips;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.AstronautItem"): typeof Internal.AstronautItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.crafttweaker.mixin.common.access.entity.AccessLightningBolt"): Internal.AccessLightningBolt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.MagentaSkirtItem$Leggings"): typeof Internal.MagentaSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.wrapper.AABBWrapper"): AABB;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2DoubleFunction"): Internal.Int2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.item.QuestBarrierBlockItem"): typeof Internal.QuestBarrierBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.brew.effect.SoulCrossMobEffect"): typeof Internal.SoulCrossMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.CoralFeature"): typeof Internal.CoralFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough"): typeof Internal.Passthrough;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.blockinformation.IBlockInformation"): Internal.IBlockInformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider"): typeof xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.PurpleSkirtItem$Leggings"): typeof Internal.PurpleSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.CustomDamageItem"): Internal.CustomDamageItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions$Deserializer"): Internal.ParticleOptions$Deserializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$AbstractImmutableCollection"): typeof Internal.ImmutableCollections$AbstractImmutableCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.common.gui.event.GuiControlChangedEvent"): typeof Internal.GuiControlChangedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BlueArchersAttireItem$Helmet"): typeof Internal.BlueArchersAttireItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DropTargetEvent"): typeof Internal.DropTargetEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.CarvingMask$Mask"): Internal.CarvingMask$Mask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ProjectileWeaponItem"): typeof Internal.ProjectileWeaponItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfyu.vinery.item.DrinkBlockSmallItem"): typeof Internal.DrinkBlockSmallItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.ReportEvidence"): typeof Internal.ReportEvidence;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.palette.Paletted2DFastBitArrayIntStorage"): typeof Internal.Paletted2DFastBitArrayIntStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator$Context"): typeof Internal.TreeDecorator$Context;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.MagentaSkirtItem"): typeof Internal.MagentaSkirtItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.rod.MoltenCoreRodItem$SmeltData"): typeof Internal.MoltenCoreRodItem$SmeltData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LootingLevelEvent"): typeof Internal.LootingLevelEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BannerItem"): typeof Internal.BannerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "questsadditions.mixinutils.IMixinQuest"): Internal.IMixinQuest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Permission"): typeof Internal.Permission;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket"): typeof Internal.ClientboundOpenSignEditorPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.HoneyCandyItem"): typeof Internal.HoneyCandyItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent"): typeof Internal.LivingEntityUseItemEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MobType"): typeof Internal.MobType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.melanx.utilitix.content.shulkerboat.ShulkerBoatItem"): typeof Internal.ShulkerBoatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.ChorusPlantFeature"): typeof Internal.ChorusPlantFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement"): typeof Internal.RandomSpreadStructurePlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ClientLevelKJS"): Internal.ClientLevelKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.SlotAccess"): Internal.SlotAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.BindingCurseEnchantment"): typeof Internal.BindingCurseEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.pattern.BlockPattern"): typeof Internal.BlockPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.world.ServerWorldExtended"): Internal.ServerWorldExtended;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlockEntityTicker"): Internal.BlockEntityTicker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.MapLimiter"): typeof Internal.MapLimiter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainBrushes"): typeof Internal.TerrainBrushes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CoralPlantBlock"): typeof Internal.CoralPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.coderbot.iris.texture.pbr.PBRSpriteHolder"): typeof Internal.PBRSpriteHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.LimeSkirtItem$Leggings"): typeof Internal.LimeSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xfacthd.framedblocks.api.block.cache.StateCache"): typeof Internal.StateCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.bakery.util.BakeryTiers"): typeof Internal.BakeryTiers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.ShapedRecipe"): typeof Internal.ShapedRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.graph.EdgePointType"): typeof Internal.EdgePointType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.handcrafted.common.items.TooltipBlockItem"): typeof Internal.TooltipBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SoundType"): typeof SoundType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.WrappedJS"): Internal.WrappedJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntLineConsumer"): Internal.DiscreteVoxelShape$IntLineConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ReflectionAccessFilter"): Internal.ReflectionAccessFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ClampedNormalFloat"): typeof Internal.ClampedNormalFloat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.EnchantmentMenu"): typeof Internal.EnchantmentMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.server.ServerEventJS"): typeof Internal.ServerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.ByteTag"): typeof Internal.ByteTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ModelBuilder$ElementBuilder"): typeof Internal.ModelBuilder$ElementBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.FurnaceMenu"): typeof Internal.FurnaceMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.comforts.common.item.HammockItem"): typeof Internal.HammockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BeaconBlock"): typeof Internal.BeaconBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BunnyTailBlackItem"): typeof Internal.BunnyTailBlackItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Helmet"): typeof Internal.ArmorItemBuilder$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DragonEggBlock"): typeof Internal.DragonEggBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.bauble.NimbusAmuletItem"): typeof Internal.NimbusAmuletItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongPredicate"): it.unimi.dsi.fastutil.longs.LongPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.AbstractReadStateHolder"): typeof Internal.AbstractReadStateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.BubbleBlockItem"): typeof Internal.BubbleBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NyliumBlock"): typeof Internal.NyliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.write.MinimapWriter"): typeof Internal.MinimapWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.slidingDoor.DoorControl"): typeof Internal.DoorControl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeInstance"): typeof Internal.AttributeInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.PaintEventJS"): typeof Internal.PaintEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.TagKeyComponent"): typeof Internal.TagKeyComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.api.render.IElementDrawer"): Internal.IElementDrawer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingData"): Internal.IGuiCategoryUIEditorSettingData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GreyPlaidSkirtItem$Leggings"): typeof Internal.GreyPlaidSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Skeleton"): typeof Internal.Skeleton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonNull"): typeof Internal.JsonNull;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.block.BlockRainbowGlass"): typeof Internal.BlockRainbowGlass;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainTools"): typeof Internal.TerrainTools;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.potatoCannon.PotatoCannonItem"): typeof Internal.PotatoCannonItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.RoyalTunicLightGreyItem$Chestplate"): typeof Internal.RoyalTunicLightGreyItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseScrolled$Pre"): typeof Internal.ScreenEvent$MouseScrolled$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.crafttweaker.mixin.common.access.level.damage.AccessDamageSources"): Internal.AccessDamageSources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.transfer.IRecipeTransferError$Type"): typeof Internal.IRecipeTransferError$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.chaosthedude.explorerscompass.util.CompassState"): typeof Internal.CompassState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.FullWhiteChocolateBarItem"): typeof Internal.FullWhiteChocolateBarItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.satisfy.brewery.effect.PartystarterEffect"): typeof Internal.PartystarterEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.DisplayInfo"): typeof Internal.DisplayInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Biome$TemperatureModifier"): typeof Internal.Biome$TemperatureModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ITickTimer"): Internal.ITickTimer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.FlowerCrownItem$Helmet"): typeof Internal.FlowerCrownItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.BigInteger"): typeof Internal.BigInteger;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mcwwindows.kikoz.util.ToolTip"): typeof com.mcwwindows.kikoz.util.ToolTip;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.server.IServerDataAPI"): Internal.IServerDataAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.enchantment.StraddleEnchantment"): typeof Internal.StraddleEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.RedKnightArmourItem$Boots"): typeof Internal.RedKnightArmourItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.FontMetrics"): typeof Internal.FontMetrics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.util.handler.FuelHandler"): typeof Internal.FuelHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.unit.MutableNumberUnit"): typeof Internal.MutableNumberUnit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.content.tools.item.BottledCloudItem"): typeof Internal.BottledCloudItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.InventoryFilterItem"): typeof Internal.InventoryFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.radar.category.EntityRadarDefaultCategories"): typeof Internal.EntityRadarDefaultCategories;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.ai.MemoryModificationCounter"): Internal.MemoryModificationCounter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.abdelaziz.canary.common.client.ClientWorldAccessor"): Internal.ClientWorldAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderGuiOverlayEvent$Pre"): typeof Internal.RenderGuiOverlayEvent$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.backend.instancing.entity.EntityTypeExtension"): Internal.EntityTypeExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.LightBluePlaidSkirtItem"): typeof Internal.LightBluePlaidSkirtItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.info.widget.InfoDisplayWidgetFactory"): Internal.InfoDisplayWidgetFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.QuickChargeEnchantment"): typeof Internal.QuickChargeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Color"): typeof Internal.Color;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.core.item.BaseBlockItem$ItemUseResult"): typeof Internal.BaseBlockItem$ItemUseResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.entity.BlockEntityJS"): typeof Internal.BlockEntityJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4dc"): Internal.Matrix4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricCategory"): typeof Internal.MetricCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownTrident"): typeof Internal.ThrownTrident;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$PrintQualityType"): typeof Internal.PageAttributes$PrintQualityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.util.StringBuilderFormattable"): Internal.StringBuilderFormattable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FlowerBoxBlock"): typeof Internal.FlowerBoxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.core.block.EntityHoldingBlock"): Internal.EntityHoldingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.bauble.SpectatorItem"): typeof Internal.SpectatorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.BlockEvent$CropGrowEvent$Post"): typeof Internal.BlockEvent$CropGrowEvent$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.item.ItemTendonWhip"): typeof Internal.ItemTendonWhip;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientLevel"): typeof Internal.ClientLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.handcrafted.common.items.CustomPaintingItem"): typeof Internal.CustomPaintingItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.citadel.item.ItemCitadelBook"): typeof Internal.ItemCitadelBook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.GuiEventListener"): Internal.GuiEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator"): Internal.ShortBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.RubyChocolateItem"): typeof Internal.RubyChocolateItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfyu.vinery.effect.ImprovedEffect"): typeof Internal.ImprovedEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator"): it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.AbstractSchoolingFish"): typeof Internal.AbstractSchoolingFish;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.equipment.armor.DivingBootsItem"): typeof Internal.DivingBootsItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.FossilFeature"): typeof Internal.FossilFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.EnderChestBlockEntity"): typeof Internal.EnderChestBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.head.SnorkelItem"): typeof Internal.SnorkelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration"): typeof Internal.SpringConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.RecipeBookType"): typeof Internal.RecipeBookType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.item.ZetaSignItem"): typeof Internal.ZetaSignItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.SteampunkersGogglesItem$Helmet"): typeof Internal.SteampunkersGogglesItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.DataSenderKJS"): Internal.DataSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.ILimited"): Internal.ILimited;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory"): Internal.ISettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.mixin.AbstractFurnaceBlockEntityAccessor"): Internal.AbstractFurnaceBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.ZoneOffset"): typeof Internal.ZoneOffset;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.core.LogEvent"): Internal.LogEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.screen.AlignMode"): typeof Internal.AlignMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.mixin.LivingEntityAccessor"): Internal.LivingEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.LabedulBlock"): typeof Internal.LabedulBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type$Mu"): typeof Internal.Type$Mu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GildedNetheriteCrownItem"): typeof Internal.GildedNetheriteCrownItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker"): Internal.IMagnetPreventionChecker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.InputEvent$MouseButton"): typeof Internal.InputEvent$MouseButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.core.util.Watcher"): Internal.Watcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.brnbrd.delightful.common.item.knife.compat.mythicbotany.AlfKnifeItem"): typeof Internal.AlfKnifeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket"): typeof Internal.ClientboundSetEquipmentPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.effect.NoWaypointsEffect"): typeof Internal.NoWaypointsEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.HealthBoostMobEffect"): typeof Internal.HealthBoostMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderBuffers"): typeof Internal.RenderBuffers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.PathfindingRenderer"): typeof Internal.PathfindingRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic"): typeof Internal.ContentsFilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.citadel.client.event.EventRenderSplashText"): typeof Internal.EventRenderSplashText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.ServerRecipeBook"): typeof Internal.ServerRecipeBook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.contraptions.render.ActorInstance"): typeof Internal.ActorInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.minimap.radar.tracker.system.ITrackedPlayerReader"): Internal.ITrackedPlayerReader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.core.data.KeyframeAnimation$AnimationBuilder"): typeof Internal.KeyframeAnimation$AnimationBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.VillagerBrainEventInternal"): typeof Internal.VillagerBrainEventInternal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PinkPetalsBlock"): typeof Internal.PinkPetalsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider"): Internal.BlockEntityRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.VasocepillosdedientesBlock"): typeof Internal.VasocepillosdedientesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.events.ModClientEvents"): typeof Internal.ModClientEvents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundInteractPacket$Handler"): Internal.ServerboundInteractPacket$Handler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StairBlock"): typeof Internal.StairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialStepInstance"): Internal.TutorialStepInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.AbstractTexture"): typeof Internal.AbstractTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.BlackPlaidSkirtItem"): typeof Internal.BlackPlaidSkirtItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonDeathPhase"): typeof Internal.DragonDeathPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.server.player.data.api.ServerPlayerDataAPI"): typeof Internal.ServerPlayerDataAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortPredicate"): Internal.ShortPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToIntFunction"): Internal.LongToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.WaterAnimal"): typeof Internal.WaterAnimal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$LineSplitter"): Internal.Display$TextDisplay$LineSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$CharacterTyped$Post"): typeof Internal.ScreenEvent$CharacterTyped$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$DisplayItem"): typeof Internal.RenderInfo$DisplayItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3dc"): Internal.Matrix4x3dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.lion.villagersplus.mixin.TropicalFishEntityInvoker"): Internal.TropicalFishEntityInvoker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.GlowItemFrame"): typeof Internal.GlowItemFrame;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ModelFile$ExistingModelFile"): typeof Internal.ModelFile$ExistingModelFile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.context.UseOnContext"): typeof Internal.UseOnContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.railwayteam.railways.mixin_interfaces.IFuelInventory"): Internal.IFuelInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeWrapper$TargetSlot"): typeof Internal.RefillUpgradeWrapper$TargetSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.item.ZetaArrowItem$Impl"): typeof Internal.ZetaArrowItem$Impl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryEventSender"): Internal.TelemetryEventSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ElytraItem"): typeof Internal.ElytraItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "ovh.corail.woodcutter.item.WoodcutterItem"): typeof Internal.WoodcutterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent"): typeof Internal.ScreenEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$ColorLogicStateShard"): typeof Internal.RenderStateShard$ColorLogicStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.server.MinecraftServerData"): typeof xaero.map.server.MinecraftServerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PlayerHeadBlock"): typeof Internal.PlayerHeadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuListener"): Internal.SpectatorMenuListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.core.config.plugins.util.PluginType"): typeof Internal.PluginType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.Level"): typeof org.apache.logging.log4j.Level;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2CharFunction"): Internal.Byte2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilderMap"): typeof Internal.RecipeComponentBuilderMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.SleepingTimeCheckEvent"): typeof Internal.SleepingTimeCheckEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.slf4j.Marker"): org.slf4j.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseListener"): Internal.MouseListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.MinecraftRemapper"): typeof Internal.MinecraftRemapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.ModelGenerator$Face"): typeof Internal.ModelGenerator$Face;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler$MetricSamplerBuilder"): typeof Internal.MetricSampler$MetricSamplerBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.piglin.AbstractPiglin"): typeof Internal.AbstractPiglin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.StructureManager"): typeof Internal.StructureManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.AlternativesEntry$Builder"): typeof Internal.AlternativesEntry$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.message.FlowMessage"): Internal.FlowMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.HitResult"): typeof Internal.HitResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PowderSnowBlock"): typeof Internal.PowderSnowBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.ForgeFlowingFluid"): typeof Internal.ForgeFlowingFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HugeMushroomBlock"): typeof Internal.HugeMushroomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.ChunkDataEvent"): typeof Internal.ChunkDataEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.cristelknight.doapi.common.item.CustomHatItem"): typeof Internal.CustomHatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingDropsEvent"): typeof Internal.LivingDropsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.backend.instancing.AbstractInstance"): typeof Internal.AbstractInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.mixin.StringSplitterAccessor"): Internal.StringSplitterAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket"): typeof Internal.ClientboundRemoveEntitiesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$CycleableValueSet"): Internal.OptionInstance$CycleableValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.PrivilegedAction"): Internal.PrivilegedAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.BlendingData"): typeof Internal.BlendingData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.StateHolder"): typeof Internal.StateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.LivingEntityRenderer"): typeof Internal.LivingEntityRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase"): typeof Internal.UpgradeWrapperBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.paulf.fairylights.server.block.LightBlock"): typeof me.paulf.fairylights.server.block.LightBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.core.IAbstractSelectionList"): Internal.IAbstractSelectionList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.LockCode"): typeof Internal.LockCode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IBlockHolder"): Internal.IBlockHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoublePredicate"): it.unimi.dsi.fastutil.doubles.DoublePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.ContainerEventHandler"): Internal.ContainerEventHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.item.PatternItem"): typeof Internal.PatternItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IEditModeConfig"): Internal.IEditModeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.AbstractObject2IntMap"): typeof Internal.AbstractObject2IntMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ShieldItem"): typeof Internal.ShieldItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.documentation.IDocumentableItem"): Internal.IDocumentableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Shearable"): Internal.Shearable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.config.IJeiConfigValue"): Internal.IJeiConfigValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.addons.oddities.item.BackpackItem"): typeof org.violetmoon.quark.addons.oddities.item.BackpackItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeFluid"): Internal.IForgeFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4dc"): Internal.Vector4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IBeeGrowable"): Internal.IBeeGrowable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion"): typeof Internal.BombExplosion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode"): typeof Internal.FirstPersonMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemOverride$Predicate"): typeof Internal.ItemOverride$Predicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.claims.api.IRegionClaimsAPI"): Internal.IRegionClaimsAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.AnyOfCondition$Builder"): typeof Internal.AnyOfCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.LimePlaidSkirtItem$Boots"): typeof Internal.LimePlaidSkirtItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer"): typeof Internal.ForkingTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ShulkerBoxBlock"): typeof Internal.ShulkerBoxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.bauble.RingOfCorrectionItem"): typeof Internal.RingOfCorrectionItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter"): typeof Internal.SurfaceWaterDepthFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.ArrayVoxelShape"): typeof Internal.ArrayVoxelShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.LlavesderegaderaBlock"): typeof Internal.LlavesderegaderaBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.ItemWrapper"): Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.sslsnpcmakermod.item.JobgiveramerorItem"): typeof Internal.JobgiveramerorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.ObjectStartedEvent"): typeof Internal.ObjectStartedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K2"): Internal.K2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.redstone.NeighborUpdater"): Internal.NeighborUpdater;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.telepathicgrunt.repurposedstructures.mixins.entities.ShulkerEntityInvoker"): Internal.ShulkerEntityInvoker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.multistate.accessor.IAreaAccessor"): Internal.IAreaAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagManager$LoadResult"): typeof Internal.TagManager$LoadResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.fluid.WhiteChocolateFluid"): typeof Internal.WhiteChocolateFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.BookContents"): typeof Internal.BookContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.illusivesoulworks.polymorph.mixin.core.AccessorAbstractFurnaceBlockEntity"): Internal.AccessorAbstractFurnaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.pathfinder.Node"): typeof Internal.Node;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.PinkKnightArmourItem"): typeof Internal.PinkKnightArmourItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.geom.Rectangle2D"): typeof Internal.Rectangle2D;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.ThreadedLevelLightEngine"): typeof Internal.ThreadedLevelLightEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.StructureSpawnOverride"): typeof Internal.StructureSpawnOverride;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.core.util.WatchManager"): typeof Internal.WatchManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.crafttweaker.api.level.CraftTweakerSavedData"): typeof Internal.CraftTweakerSavedData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterator"): Internal.LongIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.MultipartShapedBlockBuilder"): typeof Internal.MultipartShapedBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetCameraPacket"): typeof Internal.ClientboundSetCameraPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$GenericInterpolator"): Internal.Display$GenericInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Horizontal"): typeof Internal.WidgetLayout$Horizontal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor"): com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ForwardingCollection"): typeof Internal.ForwardingCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.BottledManaItem"): typeof Internal.BottledManaItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.builder.RequiredArgumentBuilder"): typeof Internal.RequiredArgumentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Font"): typeof Internal.Font;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IJeiKeyMapping"): Internal.IJeiKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.withmode.IWithModeItem"): Internal.IWithModeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.WinterSurvivalistBrownItem"): typeof Internal.WinterSurvivalistBrownItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.region.texture.BranchTextureRenderer"): typeof Internal.BranchTextureRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.block.BlockVoidWormEffigy"): typeof Internal.BlockVoidWormEffigy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$Render$Pre"): typeof Internal.ScreenEvent$Render$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.paulf.fairylights.server.item.LightItem"): typeof Internal.LightItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.tool.VitreousPickaxeItem"): typeof Internal.VitreousPickaxeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.ChunkSource"): typeof Internal.ChunkSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.model.ModelBakery$BakedCacheKey"): typeof Internal.ModelBakery$BakedCacheKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.AbstractVillager"): typeof Internal.AbstractVillager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.ZonedDateTime"): typeof Internal.ZonedDateTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.withmode.group.IToolModeGroup"): Internal.IToolModeGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerType"): typeof Internal.VillagerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec$ResultFunction"): Internal.Codec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.WitchesHatItem"): typeof Internal.WitchesHatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement"): typeof Internal.LegacySinglePoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.BdistorsionadoscBlock"): typeof Internal.BdistorsionadoscBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerTrades$ItemsForEmeralds"): typeof Internal.VillagerTrades$ItemsForEmeralds;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.BlockUtil$FoundRectangle"): typeof Internal.BlockUtil$FoundRectangle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder"): typeof Internal.SlabBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelSummary"): typeof Internal.LevelSummary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.item.AccessorItemCooldowns"): Internal.AccessorItemCooldowns;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WoolCarpetBlock"): typeof Internal.WoolCarpetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement"): typeof Internal.StructurePoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.brew.IncenseStickItem"): typeof Internal.IncenseStickItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.WandOfTheForestItem"): typeof Internal.WandOfTheForestItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "shetiphian.core.mixins.SPC_ShapedRecipe_Invoker"): Internal.SPC_ShapedRecipe_Invoker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.item.ext.ItemExtensionFactory"): Internal.ItemExtensionFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.GildedNetheriteItem$Chestplate"): typeof Internal.GildedNetheriteItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.item.ItemGhostlyPickaxe"): typeof Internal.ItemGhostlyPickaxe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker"): typeof Internal.MapBlockMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.module.ZetaModule"): typeof Internal.ZetaModule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.CreateWorldScreen"): typeof Internal.CreateWorldScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.CaramelizedMarshmellowOnAStickItem"): typeof Internal.CaramelizedMarshmellowOnAStickItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity"): typeof Internal.StorageBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.almostreliable.morejs.features.structure.StructureTemplateAccess"): Internal.StructureTemplateAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.bogey.BogeyInstance"): typeof Internal.BogeyInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.SoporteparajabonBlock"): typeof Internal.SoporteparajabonBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.api.instance.DynamicInstance"): Internal.DynamicInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.SteampunkersAttireFItem$Leggings"): typeof Internal.SteampunkersAttireFItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.minenash.seamless_loading_screen.ServerInfoExtension"): Internal.ServerInfoExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem"): typeof Internal.TerrasteelArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.Heightmap"): typeof Internal.Heightmap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.api.struct.StructType"): Internal.StructType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidBuilder"): typeof Internal.FluidBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2IntFunction"): Internal.Byte2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack"): Internal.IBitInventoryItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAddEntityPacket"): typeof Internal.ClientboundAddEntityPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BaseCoralPlantTypeBlock"): typeof Internal.BaseCoralPlantTypeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SimpleFoiledItem"): typeof Internal.SimpleFoiledItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.beachparty.item.DrinkItem"): typeof Internal.DrinkItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.ToallasmagentasBlock"): typeof Internal.ToallasmagentasBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Paint"): Internal.Paint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2BooleanFunction"): Internal.Char2BooleanFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.ReportedException"): typeof Internal.ReportedException;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.CubetadeaguaBlock"): typeof Internal.CubetadeaguaBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.random.RandomGenerator"): Internal.RandomGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.HorseFeedItem"): typeof Internal.HorseFeedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid$TintMethod"): typeof Internal.SoftFluid$TintMethod;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.AddReloadListenerEvent"): typeof Internal.AddReloadListenerEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundlePacket"): typeof Internal.BundlePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.util.IWorldObject"): Internal.IWorldObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.SoapItem"): typeof Internal.SoapItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mod.chiselsandbits.api.item.click.ClickProcessingState"): typeof Internal.ClickProcessingState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "biomesoplenty.common.block.BloodFluid$Source"): typeof Internal.BloodFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockState"): typeof Internal.BlockState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.ExtendedServerListData"): typeof Internal.ExtendedServerListData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.YellowSkirtItem$Leggings"): typeof Internal.YellowSkirtItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.botanypots.data.recipes.crop.Crop"): typeof Internal.Crop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.api.IEventListener"): Internal.IEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock"): typeof Internal.HourGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.CycleButton"): typeof Internal.CycleButton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.JEISubtypesEventJS"): typeof Internal.JEISubtypesEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.effect.EffectLavaVision"): typeof Internal.EffectLavaVision;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack"): Internal.ClientCommandRegistrationEvent$ClientCommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.BlockModelShaper"): typeof Internal.BlockModelShaper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.InventoryFilterItem$FilterSlot"): typeof Internal.InventoryFilterItem$FilterSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.PressurePlateBlockBuilder"): typeof Internal.PressurePlateBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.LocalTime"): typeof Internal.LocalTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.category.FilterObjectCategory"): typeof Internal.FilterObjectCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.common.claims.player.api.IPlayerDimensionClaimsAPI"): Internal.IPlayerDimensionClaimsAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfy.candlelight.item.armor.CookingHatItem"): typeof Internal.CookingHatItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.LabedulscBlock"): typeof Internal.LabedulscBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.WardenMaskItem$Helmet"): typeof Internal.WardenMaskItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jozufozu.flywheel.api.vertex.VertexList"): Internal.VertexList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.EmeraldCrownItem"): typeof Internal.EmeraldCrownItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry$ListenerVisitor"): Internal.GameEventListenerRegistry$ListenerVisitor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.locating.IModFile$Type"): typeof Internal.IModFile$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.mixin.MobAccessor"): Internal.MobAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "plus.dragons.createdragonlib.advancement.critereon.AbstractTrigger"): typeof Internal.AbstractTrigger;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.suggestion.Suggestions"): typeof Internal.Suggestions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.item.ItemTabIcon"): typeof Internal.ItemTabIcon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityTeleportEvent$TeleportCommand"): typeof Internal.EntityTeleportEvent$TeleportCommand;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.AmbientParticleSettings"): typeof Internal.AmbientParticleSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModInfo"): Internal.IModInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.block.MachineCasingBlock"): typeof Internal.MachineCasingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleSupplier"): Internal.DoubleSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "immersive_aircraft.item.WeaponItem"): typeof Internal.WeaponItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CaveWorldCarver"): typeof Internal.CaveWorldCarver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.geometry.IGeometryBakingContext"): Internal.IGeometryBakingContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.createconfectionery.item.SoothingHotChocolateItem"): typeof Internal.SoothingHotChocolateItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Struct$StructValidation"): Internal.Struct$StructValidation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "satisfyu.vinery.effect.LavaWalkerEffect"): typeof Internal.LavaWalkerEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientLevel$ClientLevelData"): typeof Internal.ClientLevel$ClientLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.category.ui.entry.CategorySettingsListEntry"): typeof Internal.CategorySettingsListEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Team$CollisionRule"): typeof Internal.Team$CollisionRule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.pipeline.RenderTarget"): typeof Internal.RenderTarget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.quark.mixin.mixins.accessor.AccessorLivingEntity"): Internal.AccessorLivingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "artifacts.item.wearable.belt.CrystalHeartItem"): typeof Internal.CrystalHeartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry$Wrapper"): typeof Internal.WeightedEntry$Wrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeLivingEntity"): Internal.IForgeLivingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.tom.storagemod.item.FilterItem"): typeof com.tom.storagemod.item.FilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.LimeSkirtItem$Chestplate"): typeof Internal.LimeSkirtItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.template.TemplateComponent"): typeof Internal.TemplateComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.gigaherz.toolbelt.customslots.IExtensionSlot"): Internal.IExtensionSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.Object2LongEntry"): typeof Internal.Object2LongEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Chicken"): typeof Internal.Chicken;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundKeepAlivePacket"): typeof Internal.ServerboundKeepAlivePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunction$NoiseHolder"): typeof Internal.DensityFunction$NoiseHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.DataFlavor"): typeof Internal.DataFlavor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.Monitor"): typeof Internal.Monitor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData"): typeof Internal.GuiCategoryUIEditorOptionsData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.region.MapBlock"): typeof Internal.MapBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StonecutterBlock"): typeof Internal.StonecutterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.LightBluePlaidSkirtItem$Boots"): typeof Internal.LightBluePlaidSkirtItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.AmethystCrownItem"): typeof Internal.AmethystCrownItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.Train"): typeof Internal.Train;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.lion.villagersplus.mixin.StructurePoolAccessor"): com.lion.villagersplus.mixin.StructurePoolAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration"): typeof Internal.ProbabilityFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.CraftingBookCategory"): typeof Internal.CraftingBookCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.renderable.RenderableImage"): Internal.RenderableImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock"): typeof Internal.FrameBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor"): typeof Internal.ProtectedBlockProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.FluidType"): typeof Internal.FluidType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.EntityAnchorArgument$Anchor"): typeof Internal.EntityAnchorArgument$Anchor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap"): typeof Internal.AbstractInt2ObjectMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2LongFunction"): Internal.Boolean2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.alexsmobs.item.ItemVineLasso"): typeof Internal.ItemVineLasso;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock"): typeof Internal.AbstractRopeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.StoredUserEntry"): typeof Internal.StoredUserEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.OutlineBufferSource"): typeof Internal.OutlineBufferSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "team.creative.creativecore.client.render.box.QuadGeneratorContext"): typeof Internal.QuadGeneratorContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.PositionSourceType"): Internal.PositionSourceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout"): Internal.WidgetLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.MenuAccess"): Internal.MenuAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.IdMap"): Internal.IdMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket"): typeof Internal.ClientboundSetBorderWarningDelayPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.Level$ExplosionInteraction"): typeof Internal.Level$ExplosionInteraction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureElement"): Internal.FeatureElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.almostreliable.morejs.features.villager.events.WandererTradingEventJS"): typeof Internal.WandererTradingEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.common.item.HatItemDyeable"): typeof Internal.HatItemDyeable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.StreamTagVisitor$EntryResult"): typeof Internal.StreamTagVisitor$EntryResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.neighborly.potion.UnicornPotionEffectMobEffect"): typeof Internal.UnicornPotionEffectMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe666.citadel.client.event.EventGetOutlineColor"): typeof Internal.EventGetOutlineColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.ToallasgrisesclarasBlock"): typeof Internal.ToallasgrisesclarasBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Vector"): typeof Internal.Vector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner"): Internal.ClientTooltipPositioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.coderbot.batchedentityrendering.mixin.RenderTypeAccessor"): Internal.RenderTypeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.pac.client.player.config.api.IPlayerConfigStringableOptionClientStorageAPI"): Internal.IPlayerConfigStringableOptionClientStorageAPI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.XaeroMinimapSession"): typeof Internal.XaeroMinimapSession;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.sounds.Sound"): typeof Internal.Sound;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.decoration.palettes.WindowBlock"): typeof Internal.WindowBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.families.Algebra"): Internal.Algebra;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.github.alexthe668.domesticationinnovation.server.item.RottenAppleItem"): typeof Internal.RottenAppleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "io.github.kosmx.emotes.forge.mixin.TrackedEntityAccessor"): Internal.TrackedEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.ArrowLooseEvent"): typeof Internal.ArrowLooseEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.jellysquid.mods.sodium.client.render.viewport.CameraTransform"): typeof Internal.CameraTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType"): typeof Internal.CalculationResultType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.LongTag"): typeof Internal.LongTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.botania.common.item.equipment.bauble.SnowflakePendantItem"): typeof Internal.SnowflakePendantItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.waystones.item.AbstractAttunedShardItem"): typeof Internal.AbstractAttunedShardItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.PinkSkirtItem"): typeof Internal.PinkSkirtItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ClientInfo"): typeof Internal.AbuseReportRequest$ClientInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem"): typeof Internal.PortableGridBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.UserBanListEntry"): typeof Internal.UserBanListEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration"): typeof Internal.ColumnFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.interfaces.InterfaceInstance"): typeof Internal.InterfaceInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.BitSet"): typeof Internal.BitSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.content.trains.entity.TrainIconType"): typeof Internal.TrainIconType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.TagFilterItem"): typeof Internal.TagFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.common.IXaeroMinimap"): Internal.IXaeroMinimap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.SwordItemBuilder"): typeof Internal.SwordItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.almostreliable.morejs.features.enchantment.EnchantmentTableTooltipEventJS"): typeof Internal.EnchantmentTableTooltipEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.crafttweaker.mixin.common.access.block.AccessAbstractCauldronBlock"): Internal.AccessAbstractCauldronBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ingredient.IRecipeSlotView"): Internal.IRecipeSlotView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry"): Internal.Object2FloatMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.AbstractContainerScreen"): typeof Internal.AbstractContainerScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Holder$Kind"): typeof Internal.Holder$Kind;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.ToallablancacolgBlock"): typeof Internal.ToallablancacolgBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundMoveEntityPacket"): typeof Internal.ClientboundMoveEntityPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "plus.dragons.createcentralkitchen.foundation.mixin.common.create.DeployerBlockEntityAccessor"): Internal.DeployerBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.ByteBinaryOperator"): Internal.ByteBinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRecipePacket"): typeof Internal.ClientboundRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.refinedmods.refinedstorage.api.storage.IStorage"): Internal.IStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigParser"): Internal.ConfigParser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.generators.ModelProvider"): typeof Internal.ModelProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.CatEarsGreyItem"): typeof Internal.CatEarsGreyItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xaero.map.gui.message.Message"): typeof xaero.map.gui.message.Message;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.brnbrd.delightful.common.item.CompatBlockItem"): typeof Internal.CompatBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$ValueSet"): Internal.OptionInstance$ValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DebugStickItem"): typeof Internal.DebugStickItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Half"): typeof Internal.Half;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBraceBlock"): typeof Internal.FrameBraceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Endermite"): typeof Internal.Endermite;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "me.steinborn.krypton.mod.shared.network.ClientConnectionEncryptionExtension"): Internal.ClientConnectionEncryptionExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool$Projection"): typeof Internal.StructureTemplatePool$Projection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cosmeticarmoursmod.item.AstronautItem$Helmet"): typeof Internal.AstronautItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2IntSortedMap"): Internal.Object2IntSortedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.registry.CreativeTabManager$AppendsUniquely"): Internal.CreativeTabManager$AppendsUniquely;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.WallSide"): typeof Internal.WallSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.simibubi.create.api.event.PipeCollisionEvent$Flow"): typeof Internal.PipeCollisionEvent$Flow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.moadecorbath.block.BrobleoscBlock"): typeof Internal.BrobleoscBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CropBlock"): typeof Internal.CropBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleProvider"): Internal.ParticleProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedItem"): typeof Internal.BlockTypeBasedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.TimberFrameItem"): typeof Internal.TimberFrameIte